package com.elitescloud.cloudt.system.model.vo.query.udc;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * UDC分页查询参数.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "UDC分页查询参数")
public class UdcPageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 57082475230580905L;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 0)
    private String appCode;

    /**
     * UDC编码
     */
    @ApiModelProperty(value = "UDC编码", position = 1)
    private String udcCode;

    /**
     * UDC名称
     */
    @ApiModelProperty(value = "UDC名称", position = 2)
    private String udcName;
}
