package com.elitescloud.cloudt.system.model.vo.query.user;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Set;

/**
 * 用户分页查询参数.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "用户分页查询参数")
public class UserPageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -4802194606253614538L;

    /**
     * 是否查询所有租户
     * <p>
     * 默认否，仅仅查询当前租户
     */
    @ApiModelProperty(value = "是否查询所有租户，默认否", position = 1)
    private Boolean allTenant;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 1)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 2)
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", position = 2)
    private String gender;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 3)
    private Boolean enabled;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号", position = 4)
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 5)
    private String email;

    /**
     * 账号来源
     */
    @ApiModelProperty(value = "账号来源", position = 6)
    private String sourceType;

    /**
     * 账号类型
     */
    @ApiModelProperty(value = "账号类型", position = 7)
    private String userType;

    /**
     * 账号类型
     */
    @ApiModelProperty(value = "账号类型", position = 7)
    private Set<String> userTypeList;

    /**
     * 是否包含当前账号
     */
    @ApiModelProperty(value = "是否包含当前账号", position = 8)
    private Boolean includeSelf;

    /**
     * 创建时间-开始
     */
    @ApiModelProperty(value = "创建时间-开始", position = 9)
    private LocalDateTime createTimeStart;

    /**
     * 创建时间-开始
     */
    @ApiModelProperty(value = "创建时间-截止", position = 10)
    private LocalDateTime createTimeEnd;
}
