package com.elitescloud.cloudt.system.model.vo.resp.dpr;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 数据权限-行规则返回信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Data
@ApiModel(description = "数据权限-行规则返回信息")
public class SysDprApiCustomRuleRespVO implements Serializable {
    private static final long serialVersionUID = -1068267441934803895L;

    /**
     * 规则ID
     */
    @ApiModelProperty(value = "规则ID", position = 1)
    private Long id;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称", position = 2)
    private String dprRuleName;

    /**
     * 规则字段
     */
    @ApiModelProperty(value = "规则字段", position = 3)
    private String dprRuleField;

    /**
     * 规则条件
     */
    @ApiModelProperty(value = "规则条件", position = 4)
    private DprRuleConditionEnum dprRuleCondition;
    private String dprRuleConditionName;

    /**
     * 取值方式
     */
    @ApiModelProperty(value = "取值方式", position = 5)
    private DprRuleValueTypeEnum dprRuleValueType;
    private String dprRuleValueTypeName;

    /**
     * 数据集类型
     */
    @ApiModelProperty(value = "数据集类型", position = 6)
    private String dataSet;

    /**
     * 规则值
     */
    @ApiModelProperty(value = "规则值", position = 7)
    private String dprRuleValue;
    private String dprRuleValueName;

    /**
     * 规则描述
     */
    @ApiModelProperty(value = "规则描述", position = 8)
    private String dprRuleDeclare;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段1", position = 11)
    private String bs1;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段2", position = 12)
    private String bs2;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段3", position = 13)
    private String bs3;

    public String getDprRuleConditionName() {
        if (dprRuleConditionName == null && dprRuleCondition != null) {
            return dprRuleCondition.getValueDescription();
        }
        return dprRuleConditionName;
    }

    public String getDprRuleValueTypeName() {
        if (dprRuleValueTypeName == null && dprRuleValueType != null) {
            return dprRuleValueType.getValueDescription();
        }
        return dprRuleValueTypeName;
    }
}
