package com.elitescloud.cloudt.system.model.vo.resp.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 汇率分页查询结果.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "汇率分页查询结果")
public class CurrencyRatePageRespVO implements Serializable {
    private static final long serialVersionUID = -1462445999850067967L;

    /**
     * 记录ID
     */
    @ApiModelProperty(value = "记录ID", position = 1)
    private Long id;

    /**
     * 自货币码
     */
    @ApiModelProperty(value = "自货币码", position = 2)
    private String fromCurr;

    /**
     * 自货币码
     */
    @ApiModelProperty(value = "自货币", position = 3)
    private String fromCurrName;

    /**
     * 至货币码
     */
    @ApiModelProperty(value = "至货币码", position = 4)
    private String toCurr;

    /**
     * 自货币码
     */
    @ApiModelProperty(value = "至货币", position = 5)
    private String toCurrName;

    /**
     * 汇率
     */
    @ApiModelProperty(value = "汇率", position = 6)
    private BigDecimal ratio;

    /**
     * 算法
     */
    @ApiModelProperty(value = "算法", position = 7)
    private String calMethod;

    /**
     * 算法名称
     */
    @ApiModelProperty(value = "算法名称", position = 7)
    private String calMethodName;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 8)
    private Boolean enabled;

    /**
     * 有效时间-起始
     */
    @ApiModelProperty(value = "有效时间-起始", position = 9)
    private LocalDateTime validFrom;

    /**
     * 有效时间-截止
     */
    @ApiModelProperty(value = "有效时间-截止", position = 10)
    private LocalDateTime validTo;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 11)
    private LocalDateTime createTime;
}
