package com.elitescloud.cloudt.system.model.vo.resp.extend;


import com.elitescloud.boot.web.formatter.BigDecimalFormat;
import com.elitescloud.boot.web.formatter.BigDecimalType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.NumberFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;

/**
 * 税率分页查询结果.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "税率分页查询结果")
public class TaxRatePageRespVO implements Serializable {
    private static final long serialVersionUID = -1462445999850067967L;

    /**
     * 记录ID
     */
    @ApiModelProperty(value = "记录ID", position = 1)
    private Long id;

    /**
     * 税率类型
     */
    @ApiModelProperty(value = "税率类型，UDC[cloudt-system:taxRateType]", position = 2)
    private String taxRateType;
    private String taxRateTypeName;

    /**
     * 税率编码
     */
    @ApiModelProperty(value = "税率编码", position = 2)
    private String taxRateNo;

    /**
     * 税率说明
     */
    @ApiModelProperty(value = "税率说明", position = 3)
    private String taxRateDesc;

    /**
     * 生效日期
     */
    @ApiModelProperty(value = "生效日期", position = 4)
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期", position = 5)
    private LocalDateTime validTo;


    @ApiModelProperty(value = "税率值", position = 3)
    @BigDecimalFormat(bdType = BigDecimalType.AMOUNT)
    private BigDecimal taxRateValue;

    @ApiModelProperty(value = "税率值2", position = 3)
    @BigDecimalFormat(scale = 1,roundingMode = RoundingMode.HALF_UP)
    private BigDecimal taxRateValue2;
    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 8)
    private Boolean enabled;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 11)
    private LocalDateTime createTime;

    @NumberFormat(style=NumberFormat.Style.CURRENCY)
    private Integer ceshi=123;
}
