package com.elitescloud.cloudt.system.model.vo.resp.extend;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.core.common.constant.SheetLimitStrategy;
import com.elitescloud.boot.common.param.FileInfoVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 模板信息.
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/28
 */
@Data
@ApiModel(description = "模板信息")
public class TmplEditRespVO implements Serializable {
    private static final long serialVersionUID = -51470216440641477L;

    @ApiModelProperty(value = "模板ID")
    private Long id;

    @ApiModelProperty(value = "模板名称")
    private String name;

    @ApiModelProperty(value = "模板编码")
    private String code;

    @ApiModelProperty(value = "模板文件唯一标识")
    private String fileCode;

    @ApiModelProperty(value = "模板文件名称")
    private String fileName;

    @ApiModelProperty(value = "是否是导入模板")
    private Boolean export;

    @ApiModelProperty(value = "头部所占行数，头部以下都是数据部分")
    private Integer headRow;

    @ApiModelProperty(value = "数据字段所在行")
    private Integer fieldTypeRow;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "导入数据限制")
    private Integer dataLimitPer;

    @ApiModelProperty(value = "并发阀值")
    private Integer asyncThreshold;

    @ApiModelProperty(value = "并发数量限制")
    private Integer concurrentLimit;

    @ApiModelProperty(value = "模板文件信息")
    private FileInfoVO fileInfo;

    @ApiModelProperty(value = "导出时sheet页数据量限制")
    private Integer exportSheetLimit;

    @ApiModelProperty(value = "超出sheet页数量限制后策略")
    private SheetLimitStrategy exportSheetStrategy;

    @ApiModelProperty(value = "sheet页")
    private String sheetNos;
}
