package com.elitescloud.cloudt.system.model.vo.resp.index;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 当前员工信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/6
 */
@Data
public class CurrentEmployeeRespVO implements Serializable {
    private static final long serialVersionUID = 1385056450701088651L;

    /**
     * 员工ID
     */
    @ApiModelProperty(value = "员工ID", position = 1)
    private Long id;

    /**
     * 员工账号ID
     */
    @ApiModelProperty(value = "员工账号ID", position = 2)
    private Long userId;

    /**
     * 员工账号
     */
    @ApiModelProperty(value = "员工账号", position = 3)
    private String username;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "员工姓名", position = 4)
    private String fullName;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号", position = 5)
    private String code;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工类型", position = 6)
    private String type;
    private String typeName;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务", position = 7)
    private String duty;

    /**
     * 照片编码
     */
    @ApiModelProperty(value = "照片的文件编码", position = 8)
    private String photo;

    /**
     * 入职时间
     */
    @ApiModelProperty(value = "入职时间", position = 9)
    private LocalDateTime joinTime;

    /**
     * 是否在职
     */
    @ApiModelProperty(value = "是否在职", position = 10)
    private Boolean served;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 11)
    private Boolean enabled;

    /**
     * 组织信息
     */
    @ApiModelProperty(value = "组织信息", position = 12)
    private EmployeeOrg orgInfo;

    @Data
    @ApiModel(value = "CurrentEmployeeRespVO_EmployeeOrg", description = "员工组织")
    public static class EmployeeOrg implements Serializable {
        private static final long serialVersionUID = -1315149622343919767L;

        /**
         * 组织ID
         */
        @ApiModelProperty(value = "组织ID", position = 1)
        private Long orgId;

        /**
         * 组织名称
         */
        @ApiModelProperty(value = "组织编码", position = 2)
        private String orgCode;

        /**
         * 组织名称
         */
        @ApiModelProperty(value = "组织名称", position = 3)
        private String orgName;

        /**
         * 组织所属公司的组织ID
         */
        @ApiModelProperty(value = "组织所属公司的组织ID", position = 4)
        private Long companyOrgId;

        /**
         * 组织名称
         */
        @ApiModelProperty(value = "组织所属公司的组织编码", position = 5)
        private String companyOrgCode;

        /**
         * 组织名称
         */
        @ApiModelProperty(value = "组织所属公司的组织名称", position = 6)
        private String companyOrgName;

        /**
         * 领导ID
         */
        @ApiModelProperty(value = "领导ID", position = 7)
        private Long leaderId;
        /**
         * 领导ID
         */
        @ApiModelProperty(value = "领导编码", position = 8)
        private String leaderCode;
        /**
         * 领导的账号ID
         */
        @ApiModelProperty(value = "领导的账号ID", position = 9)
        private Long leaderUserId;
        /**
         * 领导的账号
         */
        @ApiModelProperty(value = "领导的账号", position = 7)
        private String leaderUsername;
        /**
         * 领导的姓名
         */
        @ApiModelProperty(value = "领导ID", position = 7)
        private String leaderFullName;
    }
}
