package com.elitescloud.cloudt.system.model.vo.resp.index;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 用户的数据权限信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/13
 */
@Data
@ApiModel(description = "用户的数据权限信息")
public class UserDataPermissionRespVO implements Serializable {
    private static final long serialVersionUID = -5524960992067013962L;

    @ApiModelProperty(value = "登录号")
    private String username;

    @ApiModelProperty(value = "姓名")
    private String fullName;

    @ApiModelProperty(value = "角色信息")
    private List<IdCodeNameParam> roles;

    @ApiModelProperty(value = "权限行规则")
    private List<RowRule> rowRuleList;

    @ApiModelProperty(value = "列权限")
    private List<ApiField> apiFieldList;

    @Data
    @ApiModel(value = "UserDataPermissionRespVO_RowRuleList", description = "行规则")
    public static class RowRule implements Serializable {
        private static final long serialVersionUID = -5738789362882714045L;

        @ApiModelProperty("自定义值")
        private String roleRuleValue;

        @ApiModelProperty(value = "数据集")
        private String dataSet;

        @ApiModelProperty("规则关系（and-or）")
        private String dprRuleRelation;
        private String dprRuleRelationName;

        @ApiModelProperty("规则名称")
        private String dprRuleName;

        @ApiModelProperty("规则描述")
        private String dprRuleDeclare;

        @ApiModelProperty("规则字段")
        private String dprRuleField;

        @ApiModelProperty("规则条件类型")
        private String dprRuleCondition;
        @ApiModelProperty("规则条件类型名称")
        private String dprRuleConditionName;

        @ApiModelProperty("规则值类型")
        private String dprRuleValueType;
        @ApiModelProperty("规则值类型名称")
        private String dprRuleValueTypeName;

        @ApiModelProperty("系统上下文内置类型枚举")
        private String dprSysInternally;
        @ApiModelProperty("系统上下文内置类型名称")
        private String dprSysInternallyName;

        @ApiModelProperty("备用字段1")
        private String bs1;

        @ApiModelProperty("备用字段2")
        private String bs2;

        @ApiModelProperty("备用字段3")
        private String bs3;

        @ApiModelProperty("角色name")
        private Long roleId;
        @ApiModelProperty("角色编码")
        private String roleCode;

        @ApiModelProperty("角色名称")
        private String roleName;

        @ApiModelProperty("应用编码")
        private String appCode;

        @ApiModelProperty("应用名称")
        private String appName;

        @ApiModelProperty("apiId")
        private Long apiId;
        @ApiModelProperty("权限路径")
        private String apiPermissionPath;

        @ApiModelProperty("权限名称")
        private String apiPermissionName;

        @ApiModelProperty("权限编码")
        private String apiPermissionCode;

        @ApiModelProperty("请求类型")
        private String apiPermissionRequestType;

        @ApiModelProperty("描述")
        private String apiPermissionDescribe;

        @ApiModelProperty("菜单编码")
        private String menusCode;

        @ApiModelProperty("菜单名称")
        private String menusName;

        @ApiModelProperty("菜单路由")
        private String menusRoute;

        @ApiModelProperty("描述")
        private String menusDescribe;
    }

    @Data
    @ApiModel(value = "UserDataPermissionRespVO_ApiField", description = "行规则")
    public static class ApiField implements Serializable {
        private static final long serialVersionUID = -6425645931024462052L;

        @ApiModelProperty("应用编码")
        private String appCode;

        @ApiModelProperty("应用名称")
        private String appName;

        @ApiModelProperty("菜单编码")
        private String menuCode;

        @ApiModelProperty("菜单名称")
        private String menusName;

        @ApiModelProperty("菜单路由")
        private String menusRoute;

        @ApiModelProperty("描述")
        private String menusDescribe;

        @ApiModelProperty("权限路径")
        private String apiPermissionPath;

        @ApiModelProperty("权限名称")
        private String apiPermissionName;

        @ApiModelProperty("权限编码")
        private String apiPermissionCode;

        @ApiModelProperty("请求类型")
        private String apiPermissionRequestType;

        @ApiModelProperty("描述")
        private String apiPermissionDescribe;

        @ApiModelProperty("角色编码")
        private String roleCode;

        @ApiModelProperty("角色名称")
        private String roleName;

        @ApiModelProperty(name = "字段名称", notes = "")
        private String fieldName;

        @ApiModelProperty(name = "字段描述", notes = "")
        private String fieldRemark;

        @ApiModelProperty(name = "api可见", notes = "")
        private Boolean fieldApiVisible;

        @ApiModelProperty(name = "表单可见", notes = "")
        private Boolean fieldFormVisible;

        @ApiModelProperty(name = "表单可编辑", notes = "")
        private Boolean fieldFormUpdate;
    }
}
