package com.elitescloud.cloudt.system.model.vo.resp.menu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 收藏菜单.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "收藏菜单")
public class MenuFavorRespVO implements Serializable {
    private static final long serialVersionUID = -6596149117108560541L;

    @ApiModelProperty(value = "收藏记录ID")
    private Long id;

    /**
     * 菜单编码
     */
    @ApiModelProperty(value = "菜单编码", position = 1)
    private String menuCode;

    /**
     * 菜单名称
     */
    @ApiModelProperty(value = "菜单名称", position = 2)
    private String menuName;

    /**
     * 显示名称
     */
    @ApiModelProperty(value = "显示名称", position = 3)
    private String showName;

    /**
     * 顺序号
     */
    @ApiModelProperty(value = "顺序号", position = 4)
    private Integer sortNo;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 5)
    private Boolean enabled;
}
