package com.elitescloud.cloudt.system.model.vo.resp.menu;

import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 菜单树节点.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "菜单树节点")
public class MenuTreeRespVO implements Serializable {
    private static final long serialVersionUID = -6044178680494632724L;

    /**
     * 菜单编码
     */
    @ApiModelProperty(value = "菜单编码", position = 1)
    private String menuCode;
    /**
     * 菜单名称
     */
    @ApiModelProperty(value = "菜单名称", position = 2)
    private String menuName;
    /**
     * 节点类型
     * {@link MenuTreeNodeType}
     */
    @ApiModelProperty(value = "节点类型", position = 3)
    private String nodeType;
    /**
     * 父节点编码
     */
    @ApiModelProperty(value = "父节点编码", position = 4)
    private String parentMenuCode;
    /**
     * 菜单图标
     */
    @ApiModelProperty(value = "菜单图标", position = 5)
    private String menusIcon;
    /**
     * 是否隐藏
     */
    @ApiModelProperty(value = "是否隐藏", position = 6)
    private Boolean hidden;
    /**
     * 是否隐藏
     */
    @ApiModelProperty(value = "是否已禁用", position = 7)
    private Boolean enabled;
    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", position = 8)
    private Integer sortNo;
    /**
     * 是否隐藏
     */
    @ApiModelProperty(value = "是否有子节点", position = 9)
    private Boolean hasChildren;
    /**
     * 子节点列表
     */
    @ApiModelProperty(value = "子节点列表", position = 11)
    private List<MenuTreeRespVO> children;

    public String getParentMenuCode() {
        if (!StringUtils.hasText(parentMenuCode)) {
            return null;
        }
        return parentMenuCode;
    }

    public Boolean getHasChildren() {
        if (children != null && children.size() > 0) {
            return true;
        }
        return hasChildren;
    }
}
