package com.elitescloud.cloudt.system.model.vo.resp.org;

import com.elitescloud.cloudt.system.model.vo.resp.user.UserDetailRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 员工详细信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "员工详细信息")
public class EmployeeDetailRespVO implements Serializable {
    private static final long serialVersionUID = 5800505107567084416L;

    /**
     * 用户账号信息
     */
    @ApiModelProperty(value = "账号信息", position = 1)
    private UserDetailRespVO userInfo;

    /**
     * 员工组织信息
     */
    @ApiModelProperty(value = "组织信息", position = 2)
    private EmployeeOrgInfoRespVO employeeOrgInfo;
}
