package com.elitescloud.cloudt.system.model.vo.resp.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 公司分页查询结果.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "公司分页查询结果")
public class OuPageRespVO implements Serializable {
    private static final long serialVersionUID = 7297795583878651817L;

    /**
     * 记录ID
     */
    @ApiModelProperty(value = "记录ID", position = 1)
    private Long id;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码", position = 2)
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称", position = 3)
    private String ouName;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称", position = 3)
    private String ouAbbr;

    /**
     * 公司类型
     */
    @ApiModelProperty(value = "公司类型", position = 4)
    private String ouType;

    /**
     * 公司类型
     */
    @ApiModelProperty(value = "公司类型", position = 4)
    private String ouTypeName;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 5)
    private Integer sortNo;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;

    /**
     * 公司法人
     */
    @ApiModelProperty(value = "公司法人", position = 7)
    private String legalPerson;

    /**
     * 工商登记号
     */
    @ApiModelProperty(value = "工商登记号", position = 8)
    private String icRegisterNo;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 11)
    private LocalDateTime createTime;
}
