package com.elitescloud.cloudt.system.model.vo.resp.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 租户组织信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "租户组织信息")
public class TenantOrgRespVO implements Serializable {
    private static final long serialVersionUID = -3435545495224857857L;

    /**
     * 租户组织ID
     */
    @ApiModelProperty(value = "租户组织ID", position = 1)
    private Long id;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID", position = 2)
    private Long orgId;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织编码", position = 3)
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", position = 3)
    private String orgName;

    /**
     * 管理员ID
     */
    @ApiModelProperty(value = "管理员ID", position = 4)
    private Long adminUserId;

    /**
     * 管理员账号
     */
    @ApiModelProperty(value = "管理员账号", position = 4)
    private String adminUsername;

    /**
     * 管理员姓名
     */
    @ApiModelProperty(value = "管理员姓名", position = 5)
    private String adminUser;

    /**
     * 管理员手机号
     */
    @ApiModelProperty(value = "管理员手机号", position = 5)
    private String mobile;

    /**
     * 租户组织是否启用
     */
    @ApiModelProperty(value = "租户组织是否启用", position = 6)
    private Boolean enabled;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 7)
    private LocalDateTime createTime;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间", position = 8)
    private LocalDateTime modifyTime;
}
