package com.elitescloud.cloudt.system.model.vo.resp.role;

import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 权限详情.
 *
 * @author Kaiser（wang shao）
 * 2023/1/10
 */
@Data
@ApiModel(description = "权限详情")
public class PermissionDetailRespVO implements Serializable {
    private static final long serialVersionUID = -8607401789679938245L;

    /**
     * 权限ID
     */
    @ApiModelProperty(value = "权限ID", position = 1)
    private Long id;

    /**
     * 权限编码
     */
    @ApiModelProperty(value = "权限编码", position = 1)
    private String code;

    /**
     * 权限名称
     */
    @ApiModelProperty(value = "权限名称", position = 1)
    private String name;

    /**
     * 节点类型
     * {@link MenuTreeNodeType}
     */
    @ApiModelProperty(value = "节点类型", position = 2)
    private String nodeType;

    /**
     * 父权限ID
     */
    @ApiModelProperty(value = "父权限ID", position = 3)
    private Long parentId;

    /**
     * 父权限编码
     */
    @ApiModelProperty(value = "父权限编码", position = 3)
    private String parentCode;

    /**
     * 父权限编码
     */
    @ApiModelProperty(value = "父权限名称", position = 3)
    private String parentName;

    /**
     * 所属应用Id
     */
    @ApiModelProperty(value = "所属应用Id", position = 4)
    private Long appId;

    /**
     * 所属应用编码
     */
    @ApiModelProperty(value = "所属应用编码", position = 4)
    private String appCode;

    /**
     * 所属应用名称
     */
    @ApiModelProperty(value = "所属应用名称", position = 4)
    private String appName;

    /**
     * 所属菜单编码
     */
    @ApiModelProperty(value = "所属菜单编码", position = 5)
    private String menuCode;

    /**
     * 所属菜单名称
     */
    @ApiModelProperty(value = "所属菜单编码", position = 5)
    private String menuName;

    /**
     * 所属API的ID
     */
    @ApiModelProperty(value = "所属API的ID", position = 6)
    private Long apiId;

    /**
     * 所属API的编码
     */
    @ApiModelProperty(value = "所属API的编码", position = 6)
    private String apiCode;

    /**
     * 所属API的名称
     */
    @ApiModelProperty(value = "所属API的名称", position = 6)
    private String apiName;

    /**
     * 动作或路由
     */
    @ApiModelProperty(value = "动作或路由", position = 7)
    private String action;
}
