package com.elitescloud.cloudt.system.model.vo.resp.role;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 角色详细信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "角色详细信息")
public class RoleDetailRespVO implements Serializable {
    private static final long serialVersionUID = -5302468137732466520L;

    @ApiModelProperty(value = "角色ID")
    private Long id;

    /**
     * 角色编码
     */
    @ApiModelProperty(value = "角色编码", position = 1, required = true)
    @NotBlank(message = "角色编码为空")
    private String code;

    /**
     * 编号编码
     */
    @ApiModelProperty(value = "角色名称", position = 2, required = true)
    @NotBlank(message = "角色名称为空")
    private String name;

    /**
     * 分组
     */
    @ApiModelProperty(value = "分组", position = 3)
    private Long groupId;
    private String groupName;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 4)
    private Boolean enabled;

    /**
     * 业务标识，[UDC]cloudt-system:roleBusiness
     */
    @ApiModelProperty(value = "业务标识，[UDC]cloudt-system:roleBusiness", position = 5)
    private String businessKey;

    /**
     * 业务标识名称
     */
    @ApiModelProperty(value = "业务标识名称", position = 6)
    private String businessKeyName;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 11)
    private String remark;
}
