package com.elitescloud.cloudt.system.model.vo.resp.role;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 角色分页数据.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "角色分页数据")
public class RolePageRespVO implements Serializable {
    private static final long serialVersionUID = -452568360481668838L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 角色编码
     */
    @ApiModelProperty(value = "角色编码", position = 2)
    private String code;

    /**
     * 编号编码
     */
    @ApiModelProperty(value = "角色名称", position = 3)
    private String name;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 4)
    private Boolean enabled;

    /**
     * 业务标识
     */
    @ApiModelProperty(value = "业务标识", position = 5)
    private String businessKey;
    private String businessKeyName;

    /**
     * 分组
     */
    @ApiModelProperty(value = "分组", position = 6)
    private Long groupId;
    private String groupName;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 11)
    private LocalDateTime createTime;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间", position = 12)
    private LocalDateTime modifyTime;
}
