package com.elitescloud.cloudt.system.model.vo.resp.role;

import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 角色权限.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "角色权限")
public class RolePermissionRespVO implements Serializable {
    private static final long serialVersionUID = 6535685896888907235L;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码", position = 1)
    private String code;
    /**
     * 权限名称
     */
    @ApiModelProperty(value = "权限名称", position = 2)
    private String name;
    /**
     * 节点类型
     * {@link MenuTreeNodeType}
     */
    @ApiModelProperty(value = "节点类型", position = 3)
    private String nodeType;
    /**
     * 父节点编码
     */
    @ApiModelProperty(value = "父节点编码", position = 4)
    private String parentCode;
    /**
     * 菜单图标
     */
    @ApiModelProperty(value = "图标", position = 5)
    private String menusIcon;

    /**
     * 路由地址
     */
    @ApiModelProperty(value = "路由地址", position = 5)
    private String route;
    /**
     * 是否已选择
     */
    @ApiModelProperty(value = "是否已选择", position = 6)
    private Boolean checked;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 7)
    private Integer sortNo;

    /**
     * 挂载接口数量
     */
    @ApiModelProperty(value = "挂载接口数量", position = 8)
    private Long apiNum;

    /**
     * 是否隐藏
     */
    @ApiModelProperty(value = "是否有子节点", position = 9)
    private Boolean hasChildren;
    /**
     * 子节点列表
     */
    @ApiModelProperty(value = "子节点列表", position = 11)
    private List<RolePermissionRespVO> children;

    public Boolean getHasChildren() {
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return hasChildren;
    }

    public String getParentCode() {
        if (!StringUtils.hasText(parentCode)) {
            return null;
        }
        return parentCode;
    }

    public Long getApiNum() {
        if (apiNum == null) {
            return 0L;
        }
        return apiNum;
    }
}
