package com.elitescloud.cloudt.system.model.vo.resp.sequence;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 发号规则详细信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "发号规则详细信息")
public class SeqRuleDetailsRespVO implements Serializable {
    private static final long serialVersionUID = -422264350225893508L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 2)
    private String appCode;

    /**
     * 规则编码
     */
    @ApiModelProperty(value = "规则编码", position = 2)
    private String ruleCode;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称", position = 3)
    private String ruleName;

    /**
     * 取号示例
     */
    @ApiModelProperty(value = "取号示例", position = 4)
    private String sampleCode;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 5)
    private Boolean enabled;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 5)
    private String remark;

    /**
     * 规则明细
     */
    @ApiModelProperty(value = "规则明细", position = 6)
    private List<SeqRuleDetailRecordRespVO> detailsList;
}
