package com.elitescloud.cloudt.system.model.vo.resp.udc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * UDC分页数据.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "UDC分页数据")
public class UdcPageRespVO implements Serializable {
    private static final long serialVersionUID = -5481161867691415748L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * UDC编码
     */
    @ApiModelProperty(value = "UDC编码", position = 2)
    private String udcCode;

    /**
     * UDC名称
     */
    @ApiModelProperty(value = "UDC名称", position = 3)
    private String udcName;

    /**
     * 上级UDC编码
     */
    @ApiModelProperty(value = "上级UDC编码", position = 4)
    private String parentUdcCode;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 11)
    private LocalDateTime createTime;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间", position = 12)
    private LocalDateTime modifyTime;
}
