package com.elitescloud.cloudt.system.model.vo.save.devops;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 导出基础数据信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/27
 */
@Data
@ApiModel(description = "导出基础数据信息")
public class ExportBasicDataSaveVO implements Serializable {
    private static final long serialVersionUID = 8765870831377150797L;

    @ApiModelProperty(value = "是否全量", position = 1)
    private Boolean allData;

    @ApiModelProperty(value = "数据版本", position = 2)
    private String dataVersion;

    @ApiModelProperty(value = "数据类型", position = 3, hidden = true)
    private String dataType;

    @ApiModelProperty(value = "租户编码", position = 4, hidden = true)
    private String tenantCode;

    @ApiModelProperty(value = "说明", position = 5)
    private String description;
}
