package com.elitescloud.cloudt.system.model.vo.save.dpr;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 数据权限-行规则.
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Data
@ApiModel(description = "数据权限-行规则保存信息")
public class SysDprApiCustomRuleSaveVO implements Serializable {
    private static final long serialVersionUID = 8243240619082255892L;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称", position = 2)
    private String dprRuleName;

    /**
     * 规则字段
     */
    @ApiModelProperty(value = "规则字段", position = 3)
    private String dprRuleField;

    /**
     * 规则条件
     */
    @ApiModelProperty(value = "规则条件", position = 4)
    private DprRuleConditionEnum dprRuleCondition;

    /**
     * 取值方式
     */
    @ApiModelProperty(value = "取值方式", position = 5, required = true)
    @NotNull(message = "取值方式不能为空")
    private DprRuleValueTypeEnum dprRuleValueType;

    /**
     * 数据集类型
     */
    @ApiModelProperty(value = "数据集类型", position = 6)
    private String dataSet;

    /**
     * 规则值
     */
    @ApiModelProperty(value = "规则值", position = 7, required = true)
    @NotBlank(message = "规则值不能为空")
    private String dprRuleValue;

    /**
     * 规则值名称
     */
    @ApiModelProperty(value = "规则值名称", position = 8)
    private String dprRuleValueName;

    /**
     * 规则描述
     */
    @ApiModelProperty(value = "规则描述", position = 11)
    private String dprRuleDeclare;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段1", position = 21)
    private String bs1;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段2", position = 22)
    private String bs2;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段3", position = 23)
    private String bs3;
}
