package com.elitescloud.cloudt.system.model.vo.save.dpr;

import com.elitescloud.boot.datasecurity.dpr.content.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 行规则组的行规则表 data permission row
 *
 * @author chen
 */


@Data
@Accessors(chain = true)
@ApiModel(value = "SysDprRuleAddVO", description = "行规则组的行规则表 data permission row")
public class SysDprRuleGroupRuleAddVO implements Serializable {
    @ApiModelProperty("（非空）规则组id")
    @NotNull(message = "规则组id不能空")
    Long dprRuleGroupId;

    @ApiModelProperty("规则关系（and-or）")
    @NotNull(message = "规则关系不能为空")
    DprRuleRelationEnum dprRuleRelation;

    @ApiModelProperty("（非空）规则名称")
    @NotBlank(message = "规则名称")
    String dprRuleName;

    @ApiModelProperty("规则描述")
    String dprRuleDeclare;

    @ApiModelProperty("（非空）规则字段")
    @NotBlank(message = "规则字段")
    String dprRuleField;

    @ApiModelProperty("（非空）规则字段类型枚举")
    @NotNull
    DprRuleFieldTypeEnum dprRuleFieldType;

    @ApiModelProperty("（非空）规则字段描述")
    @NotNull(message = "规则字段描述")
    String dprRuleFieldDeclare;

    @ApiModelProperty("（非空）规则条件枚举")
    @NotNull(message = "规则条件枚举")
    DprRuleConditionEnum dprRuleCondition;

    @ApiModelProperty("规则值类型枚举")
    DprRuleValueTypeEnum dprRuleValueType;

    @ApiModelProperty("规则值")
    String dprRuleValue;

    @ApiModelProperty("规则值说明")
    String dprRuleValueDeclare;

    @ApiModelProperty("系统内置上下文枚举")
    DprSysInternallyEnum dprSysInternally;

    @ApiModelProperty("角色自定义选择组件枚举")
    DprRoleCustomAppEnum dprRoleCustomApp;

    @ApiModelProperty("排序")
    Float dprRuleGroupRuleOrder;
}