package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 前端表格配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/20
 */
@Data
@ApiModel(description = "前端表格配置")
public class FrontTableCfgSaveVO implements Serializable {
    private static final long serialVersionUID = -5767745182899506728L;

    /**
     * 表格编码
     */
    @ApiModelProperty(value = "表格编码", required = true)
    @NotBlank(message = "表格编码不能为空")
    private String tableCode;

    /**
     * 配置内容
     */
    @ApiModelProperty(value = "配置内容")
    private String config;
}
