package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 三方接口保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/15
 */
@Data
@ApiModel(description = "三方接口保存信息")
public class ThirdApiLogSaveVO implements Serializable {
    private static final long serialVersionUID = 4278330152038430319L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    @NotNull(message = "ID为空")
    private Long id;

    /**
     * 服务端地址
     */
    @ApiModelProperty(value = "服务端地址", position = 2)
    private String serverAddr;

    /**
     * 请求的接口地址
     */
    @ApiModelProperty(value = "请求的接口地址", position = 3)
    private String uri;

    /**
     * 请求方式
     */
    @ApiModelProperty(value = "请求方式", position = 4)
    private HttpMethod reqMethod;

    /**
     * 请求的查询参数
     */
    @ApiModelProperty(value = "请求的查询参数", position = 5)
    private String reqQueryParamsJson;

    /**
     * 请求体
     */
    @ApiModelProperty(value = "请求体", position = 6)
    private String reqBody;

    /**
     * 请求头
     */
    @ApiModelProperty(value = "请求头", position = 7)
    private String reqHeadersJson;
}
