package com.elitescloud.cloudt.system.model.vo.save.index;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 修改登录密码.
 *
 * @author Kaiser（wang shao）
 * 2022/11/8
 */
@Data
@ApiModel(description = "修改登录密码")
public class ModifyPasswordSaveVO implements Serializable {
    private static final long serialVersionUID = 4899672710776292039L;

    @ApiModelProperty(value = "当前密码", position = 1, required = true)
    @NotBlank(message = "当前密码为空")
    private String pd;

    @ApiModelProperty(value = "新密码", position = 2, required = true)
    @NotBlank(message = "新密码为空")
    private String pdNew;

    @ApiModelProperty(value = "重新输入密码", position = 3, required = true)
    @NotBlank(message = "重新输入密码为空")
    private String pdRepeat;
}
