package com.elitescloud.cloudt.system.model.vo.save.menu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 收藏菜单.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "收藏菜单")
public class MenuFavorSaveVO implements Serializable {
    private static final long serialVersionUID = 8234620206436616728L;

    @ApiModelProperty(value = "ID")
    private Long id;

    /**
     * 菜单编码
     */
    @ApiModelProperty(value = "菜单编码", position = 1, required = true)
    @NotBlank(message = "菜单编码为空")
    private String menuCode;

    /**
     * 显示名称
     */
    @ApiModelProperty(value = "显示名称", position = 2, required = true)
    @NotBlank(message = "显示名称为空")
    private String showName;

    /**
     * 顺序号
     */
    @ApiModelProperty(value = "顺序号", position = 4)
    private Integer sortNo;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 5)
    private Boolean enabled;
}
