package com.elitescloud.cloudt.system.model.vo.save.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/28
 */
@Data
@ApiModel(description = "保存租户组织信息")
public class OrgTenantSaveVO implements Serializable {
    private static final long serialVersionUID = 8932666450505459628L;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID", required = true, position = 1)
    @NotNull(message = "组织ID为空")
    private Long orgId;

    /**
     * 管理员ID
     */
    @ApiModelProperty(value = "管理员ID", position = 2)
    private Long adminUserId;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用，默认是", position = 3)
    private Boolean enabled;
}
