package com.elitescloud.cloudt.system.model.vo.save.org;

import com.elitescloud.boot.common.param.AreaVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 公司保存参数.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "公司保存参数")
public class OuSaveVO implements Serializable {
    private static final long serialVersionUID = 8385085789573278133L;

    /**
     * 记录ID，编辑时不可为空
     */
    @ApiModelProperty(value = "记录ID，编辑时不可为空", position = 1)
    private Long id;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码", position = 2, required = true)
    @NotBlank(message = "公司编码不可为空")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称", position = 3, required = true)
    @NotBlank(message = "公司名称不可为空")
    private String ouName;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称", position = 3)
    private String ouAbbr;

    /**
     * 公司类型
     */
    @ApiModelProperty(value = "公司类型，[UDC]cloudt-system:ouType", position = 4)
    private String ouType;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 5)
    private Integer sortNo;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;

    /**
     * 公司法人
     */
    @ApiModelProperty(value = "公司法人", position = 11)
    private String legalPerson;

    /**
     * 工商登记号
     */
    @ApiModelProperty(value = "工商登记号", position = 12)
    private String icRegisterNo;

    /**
     * 电话号-区号
     */
    @ApiModelProperty(value = "电话号-区号", position = 13)
    private String phonePrefix;

    /**
     * 电话号-号码
     */
    @ApiModelProperty(value = "电话号-号码", position = 13)
    private String phoneNum;

    /**
     * 公司邮箱
     */
    @ApiModelProperty(value = "公司邮箱", position = 14)
    private String email;

    /**
     * 法人公司ID
     */
    @ApiModelProperty(value = "法人公司ID", position = 15)
    private Long legalOuId;

    /**
     * 所属区域，[UDC]cloudt-system:region
     */
    @ApiModelProperty(value = "所属区域，[UDC]cloudt-system:region", position = 16)
    private String region;

    /**
     * 所在地
     */
    @ApiModelProperty(value = "所在地", position = 17)
    private AreaVO area;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址", position = 18)
    private String address;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 31)
    private String remark;
}
