package com.elitescloud.cloudt.system.model.vo.save.role;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 角色关联的权限信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/17
 */
@Data
@ApiModel(description = "角色关联的权限信息")
public class RoleAppPermissionSaveVO implements Serializable {
    private static final long serialVersionUID = 801497286598895434L;

    @ApiModelProperty(value = "应用编码", position = 1, required = true)
    @NotBlank(message = "应用编码为空")
    private String appCode;

    @ApiModelProperty(value = "权限列表", position = 2)
    @Valid
    private List<RolePermissionSaveVO> permissionList;
}
