package com.elitescloud.cloudt.system.model.vo.save.role;

import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 角色权限保存信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "角色权限保存信息")
public class RolePermissionSaveVO implements Serializable {
    private static final long serialVersionUID = -1036429387679456581L;

    /**
     * 权限编码
     */
    @ApiModelProperty(value = "权限编码", position = 1, required = true)
    @NotBlank(message = "权限编码为空")
    private String code;

    /**
     * 节点类型
     * {@link MenuTreeNodeType}
     */
    @ApiModelProperty(value = "节点类型", position = 2, required = true)
    @NotBlank(message = "节点类型为空")
    private String nodeType;
}
