package com.elitescloud.cloudt.system.model.vo.save.udc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * UDC值.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "UDC值")
public class UdcValueSaveVO implements Serializable {
    private static final long serialVersionUID = 8264632358015083825L;

    /**
     * 值ID
     */
    @ApiModelProperty(value = "值ID", position = 1)
    private Long id;

    /**
     * 值编码
     */
    @ApiModelProperty(value = "值编码", position = 2, required = true)
    @NotBlank(message = "值编码为空")
    private String udcValueCode;

    /**
     * 显示名称
     */
    @ApiModelProperty(value = "显示名称", position = 3, required = true)
    @NotBlank(message = "显示名称为空")
    private String udcValueName;

    /**
     * 别名
     */
    @ApiModelProperty(value = "别名", position = 4)
    private String valueAliasName;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 5)
    private Integer udcOrder;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean allowStart;

    /**
     * 上级UDC值
     */
    @ApiModelProperty(value = "上级UDC值", position = 7)
    private String parentUdcValueCode;
}
