package com.elitescloud.cloudt.system.model.vo.sbean;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author : chen.niu
 * @description :
 * : 2023/2/1 08:58
 */
@Data
@SearchBean(
        tables = TableNameConstant.SYS_DPCR_API_FIELDS_DO + " rarg"
                + " inner join " + TableNameConstant.SYS_ROLE_DO + "  role on rarg.role_id=role.id "
                + " inner join  " + TableNameConstant.SYS_PLATFORM_APP + "   app on rarg.app_code=app.app_code"
                + " inner join  " + TableNameConstant.SYS_PLATFORM_MENUS + "   menus on rarg.menu_code=menus.menus_code"
                + " inner join  " + TableNameConstant.SYS_PLATFORM_API_MANAGE + "   api on rarg.api_code=api.api_code"
        ,       // 两表关联
        where = "rarg.delete_flag = 0",
        autoMapTo = "rarg"
)
public class SysDprRoleApiDataColumnRuleListQueryBean {

    private static final long serialVersionUID = -5228800510752566741L;
    @ApiModelProperty("角色id")
    Long roleId;

    @ApiModelProperty("应用id")
    @DbField(value = "app.id")
    Long appId;

    @ApiModelProperty("菜单编码-因有自定义菜单，采用编码")
    String menuCode;

    @ApiModelProperty("APIid")
    @DbField(value = "api.id")
    Long apiId;

//    @ApiModelProperty("列字段")
//    String columnFields;
//
//    @ApiModelProperty("列字段是否有权限")
//    Boolean columnFieldsExists;

    @ApiModelProperty(name = "字段名称",notes = "")
    private String fieldName ;

    @ApiModelProperty(name = "字段描述",notes = "")
    private String fieldRemark ;

    @ApiModelProperty(name = "api可见",notes = "")
    private Boolean fieldApiVisible ;

    @ApiModelProperty(name = "表单可见",notes = "")
    private Boolean fieldFormVisible ;

    @ApiModelProperty(name = "表单可编辑",notes = "")
    private Boolean fieldFormUpdate;


    /***角色信息**/
    @ApiModelProperty("角色编码")
    @DbField(value = "role.code")
    private String roleCode;

    @ApiModelProperty("角色名称")
    @DbField(value = "role.name")
    private String roleName;

    @ApiModelProperty(value = "角色类型")
    @DbField(value = "role.type")
    private String roleType;

    @ApiModelProperty(value = "类型标识")
    @DbField(value = "role.type_id")
    private String roleTypeId;

    /**
     * 应用信息
     */
    @ApiModelProperty("应用编码")
    @DbField(value = "app.app_code")
    String appCode;

    @ApiModelProperty("应用名称")
    @DbField(value = "app.app_name")
    String appName;

    @ApiModelProperty("应用类型")
    @DbField(value = "app.app_type")
    String appType;

    @ApiModelProperty("描述")
    @DbField(value = "app.app_describe")
    String appDescribe;

    /**
     * api接口信息
     ***/
    @ApiModelProperty("权限路径")
    @DbField(value = "api.api_path")
    String apiPermissionPath;

    @ApiModelProperty("权限名称")
    @DbField(value = "api.api_name")
    String apiPermissionName;

    @ApiModelProperty("权限编码")
    @DbField(value = "api.api_code")
    String apiPermissionCode;

    @ApiModelProperty("请求类型")
    @DbField(value = "api.request_type")
    String apiPermissionRequestType;

    @ApiModelProperty("描述")
    @DbField(value = "api.api_describe")
    String apiPermissionDescribe;

    /**
     * 菜单信息
     **/

    @ApiModelProperty("菜单归属应用")
    @DbField(value = "menus.menus_app_code")
    String menusAppCode;

    @ApiModelProperty("菜单名称")
    @DbField(value = "menus.menus_name")
    String menusName;

    @ApiModelProperty("菜单类型 业务,系统")
    @DbField(value = "menus.menus_type")
    String menusType;

    @ApiModelProperty("节点类型 菜单,按钮")
    @DbField(value = "menus.node_type")
    String menusNodeType;

    @ApiModelProperty("菜单编码")
    @DbField(value = "menus.menus_code")
    String menusCode;

    @ApiModelProperty("上级菜单编码")
    @DbField(value = "menus.menus_parent_code")
    String menusParentCode;

    @ApiModelProperty("菜单路由")
    @DbField(value = "menus.menus_route")
    String menusRoute;

    @ApiModelProperty("描述")
    @DbField(value = "menus.menus_describe")
    String menusDescribe;
}
