package com.elitescloud.cloudt.system.model.vo.sbean;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * @author : chen.niu
 * @description :
 * : 2023/1/31 00:25
 */
@Data
@SearchBean(
        tables = TableNameConstant.SYS_DPR_ROLE_API_RULE_DO + " rarg"
                + " inner join " + TableNameConstant.SYS_ROLE_DO + "  role on rarg.role_id=role.id "
                + " inner join  " + TableNameConstant.SYS_PLATFORM_APP + "   app on rarg.app_code=app.app_code"
                + " inner join  " + TableNameConstant.SYS_PLATFORM_MENUS + "   menus on rarg.menu_code=menus.menus_code"
                + " inner join  " + TableNameConstant.SYS_PLATFORM_API_MANAGE + "   api on rarg.api_code=api.api_code"
        ,       // 两表关联
        where = "rarg.delete_flag = 0",
        autoMapTo = "rarg"
)
public class SysDprRoleApiDataRuleListQueryBean {
    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty("租户tenantId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;

    /**
     * 角色规则配置信息
     **/
    @ApiModelProperty("自定义值")
    private String roleRuleValue;

    @ApiModelProperty("自定义值填写类型")
    private String roleRuleValueType;

    @ApiModelProperty("规则排序")
    private Double ruleOrder;


    /**行规则信息  **/
    @ApiModelProperty("行规则id")
    private Long dprRuleId;
    @ApiModelProperty("规则关系（and-or）")
//    @DbField(value = "rule.dpr_rule_relation")
    private String dprRuleRelation;
    //    @DbField(value = "rule.dpr_rule_relation_name")
    private String dprRuleRelationName;

    @ApiModelProperty("规则名称")
//    @DbField(value = "rule.dpr_rule_name")
    private String dprRuleName;

    @ApiModelProperty("规则描述")
//    @DbField(value = "rule.dpr_rule_declare")
    private String dprRuleDeclare;

    @ApiModelProperty("规则字段")
//    @DbField(value = "rule.dpr_rule_field")
    private String dprRuleField;

    @ApiModelProperty("规则字段类型")
//    @DbField(value = "rule.dpr_rule_field_type")
    private String dprRuleFieldType;
    @ApiModelProperty("规则条件类型名称")
//    @DbField(value = "rule.dpr_rule_field_type_name")
    private String dprRuleFieldTypeName;

    @ApiModelProperty("业务数据集")
    private String dataSet;

    @ApiModelProperty("规则字段描述")
//    @DbField(value = "rule.dpr_rule_field_declare")
    private String dprRuleFieldDeclare;

    @ApiModelProperty("规则条件类型")
//    @DbField(value = "rule.dpr_rule_condition")
    private String dprRuleCondition;
    @ApiModelProperty("规则条件类型名称")
//    @DbField(value = "rule.dpr_rule_condition_name")
    private String dprRuleConditionName;

    @ApiModelProperty("规则值类型")
//    @DbField(value = "rule.dpr_rule_value_type")
    private String dprRuleValueType;
    @ApiModelProperty("规则值类型名称")
//    @DbField(value = "rule.dpr_rule_value_type_name")
    private String dprRuleValueTypeName;

    @ApiModelProperty("规则值")
//    @DbField(value = "rule.dpr_rule_value")
    private String dprRuleValue;

    @ApiModelProperty("规则值说明")
//    @DbField(value = "rule.dpr_rule_value_declare")
    private String dprRuleValueDeclare;

    @ApiModelProperty("系统上下文内置类型枚举")
//    @DbField(value = "rule.dpr_sys_internally")
    private String dprSysInternally;
    @ApiModelProperty("系统上下文内置类型名称")
//    @DbField(value = "rule.dpr_sys_internally_name")
    private String dprSysInternallyName;

    /**
     * 是否是数据范围
     */
    private Boolean dataRange;
    /**
     * 特用字段1
     */
    private String bs1;

    /**
     * 特用字段2
     */
    private String bs2;

    /**
     * 特用字段3
     */
    private String bs3;


    /***角色信息**/
    @ApiModelProperty("角色name")
    private Long roleId;
    @ApiModelProperty("角色编码")
    @DbField(value = "role.code")
    private String roleCode;

    @ApiModelProperty("角色名称")
    @DbField(value = "role.name")
    private String roleName;

    @ApiModelProperty(value = "角色类型")
    @DbField(value = "role.type")
    private String roleType;

    @ApiModelProperty(value = "类型标识")
    @DbField(value = "role.type_id")
    private String roleTypeId;

    /**
     * 应用信息
     */
    @ApiModelProperty("应用appId")
    @DbField(value = "app.id")
    private Long appId;
    @ApiModelProperty("应用编码")
    @DbField(value = "app.app_code")
    private String appCode;

    @ApiModelProperty("应用名称")
    @DbField(value = "app.app_name")
    private String appName;

    @ApiModelProperty("应用类型")
    @DbField(value = "app.app_type")
    private String appType;

    @ApiModelProperty("描述")
    @DbField(value = "app.app_describe")
    private String appDescribe;

    /**
     * api接口信息
     ***/
    @ApiModelProperty("apiId")
    @DbField(value = "api.id")
    private Long apiId;
    @ApiModelProperty("权限路径")
    @DbField(value = "api.api_path")
    private String apiPermissionPath;

    @ApiModelProperty("权限名称")
    @DbField(value = "api.api_name")
    private String apiPermissionName;

    @ApiModelProperty("权限编码")
    @DbField(value = "api.api_code")
    private String apiPermissionCode;

    @ApiModelProperty("请求类型")
    @DbField(value = "api.request_type")
    private String apiPermissionRequestType;

    @ApiModelProperty("描述")
    @DbField(value = "api.api_describe")
    private String apiPermissionDescribe;


    /**
     * 菜单信息
     **/
    @ApiModelProperty("菜单归属应用")
    @DbField(value = "menus.menus_app_code")
    private String menusAppCode;

    @ApiModelProperty("菜单名称")
    @DbField(value = "menus.menus_name")
    private String menusName;

    @ApiModelProperty("菜单类型 业务,系统")
    @DbField(value = "menus.menus_type")
    private String menusType;

    @ApiModelProperty("节点类型 菜单,按钮")
    @DbField(value = "menus.node_type")
    private String menusNodeType;

    @ApiModelProperty("菜单编码")
    @DbField(value = "menus.menus_code")
    private String menusCode;

    @ApiModelProperty("上级菜单编码")
    @DbField(value = "menus.menus_parent_code")
    private String menusParentCode;

    @ApiModelProperty("菜单路由")
    @DbField(value = "menus.menus_route")
    private String menusRoute;

    @ApiModelProperty("描述")
    @DbField(value = "menus.menus_describe")
    private String menusDescribe;


    /**
     * 规则组信息
     */
//    @ApiModelProperty("行规则组id")
//    Long dprRuleGroupId;
//    @ApiModelProperty("规则组名称")
//    @DbField(value = "rg.dpr_rule_group_name")
//    String dprRuleGroupName;
//
//    @ApiModelProperty("规则组说明")
//    @DbField(value = "rg.dpr_rule_group_declare")
//    String dprRuleGroupDeclare;
//
//    @ApiModelProperty("是否启用")
//    @DbField(value = "rg.group_enable")
//    Boolean dprRuleGroupGroupEnable;
//
//    @ApiModelProperty("公共，定制")
//    @DbField(value = "rg.dpr_rule_group_type")
//    String dprRuleGroupType;
//    @ApiModelProperty("排序")
//    @DbField(value = "rg.dpr_rule_group_order")
//    Float dprRuleGroupOrder;
//
}
