package com.elitescloud.cloudt.system.modules.message.bo;

import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.RequiredArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 发送模板信息的业务对象。
 * @date : 2023-11-21 14:24
 */
@Data
@RequiredArgsConstructor
public class SendTempLateMsgBO {
    /**
     * 内容参数
     */
    private Map<String, String> contentReplaceMap;
    /**
     * 标题参数
     */
    private Map<String, String> titleReplaceMap;
    /**
     * 消息关联参数，详情页存储
     */
    private Map<String, String> mesJoinParamMap;
    /**
     * 发送批量号
     */
    private String uuidBatch;
    /**
     * 发送人
     */
    private MsgSendEmployeeUserDTO sendUser;
    /**
     * 接收人
     */
    private List<EmployeePagedRespBean> recipientEmployeeList;
    /**
     * 抄送人  邮件使用
     */
    private List<EmployeePagedRespBean> carbonUserEmployeeList;
    /**
     * 附件编码
     */
    private List<String> fileCodes;
    /**
     * 模板编码
     */
    private String templateCode;
    /**
     * 模板信息
     */
    private SysMsgTemplateDO templateDo;
    /**
     * 模板ID查询出来的全部模板发送类型配置信息
     */
    private Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> groupedSendMap;
    /**
     * 默认接收人
     */
    private Map<MsgSendTypeEnum, List<EmployeePagedRespBean>> defaultReceiverMap;

    public SendTempLateMsgBO(Map<String, String> contentReplaceMap,
                             Map<String, String> titleReplaceMap,
                             Map<String, String> mesJoinParamMap,
                             String uuidBatch,
                             MsgSendEmployeeUserDTO sendUser,
                             List<EmployeePagedRespBean> recipientEmployeeList,
                             List<EmployeePagedRespBean> carbonUserEmployeeList,
                             List<String> fileCodes,
                             String templateCode) {
      this.contentReplaceMap=contentReplaceMap;
      this.titleReplaceMap=titleReplaceMap;
      this.mesJoinParamMap=mesJoinParamMap;
      this.uuidBatch=uuidBatch;
      this.sendUser=sendUser;
      this.recipientEmployeeList=recipientEmployeeList;
      this.carbonUserEmployeeList=carbonUserEmployeeList;
      this.fileCodes=fileCodes;
      this.templateCode=templateCode;
    }
}
