package com.elitescloud.cloudt.system.modules.message.controller;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.modules.message.service.SysMsgTemplateService;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgTemplateQueryVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateAndConfigSaveVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateAndConfigUpdateVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateDeleteVO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplatePageRespVO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateRespVO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : chen.niu
 * @description : 消息模板管理
 * @date : 2023/5/23 12:28
 */
@Api(tags = "消息模板管理")
@RestController
@RequestMapping(value = "/msg/sysMsgTemplate", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class SysMsgTemplateController {

    private final SysMsgTemplateService sysMsgTemplateService;

    public SysMsgTemplateController(SysMsgTemplateService sysMsgTemplateService) {
        this.sysMsgTemplateService = sysMsgTemplateService;
    }
    @PostMapping("/query")
    @ApiOperation(value = "分页查询消息模板")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SysMsgTemplatePageRespVO>> getSysMsgTemplateList(@RequestBody SysMsgTemplateQueryVO queryVO) {
        return sysMsgTemplateService.getSysMsgTemplateList(queryVO);
    }
    @GetMapping("/{id}/{queryTemplateConfigFlag}")
    @ApiOperation(value = "获取消息模板详情")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "id", value = "消息模板ID", required = true)
    public ApiResult<SysMsgTemplateRespVO> getSysMsgTemplate(@PathVariable("id") Long id,
                                                             @PathVariable("queryTemplateConfigFlag")  Boolean queryTemplateConfigFlag ) {
        return sysMsgTemplateService.getSysMsgTemplate(id,queryTemplateConfigFlag);
    }

    @PostMapping("/config/save")
    @ApiOperation(value = "新增消息模板与配置")
    @ApiOperationSupport(order = 3)
    public ApiResult<Long> templateAndConfigSave(@RequestBody TemplateAndConfigSaveVO dto) {
        return  sysMsgTemplateService.templateAndConfigSave(dto);

    }
    @PostMapping("/config/update/{id}")
    @ApiOperation(value = "修改消息模板与配置")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> templateAndConfigUpdate(@PathVariable Long id,@RequestBody TemplateAndConfigUpdateVO dto) {
//        模板编码不能修改，名称描述直接修改
//        发送类型渠道对象，全删全插
        return sysMsgTemplateService.templateAndConfigUpdate(id,dto);
    }

    @PutMapping("/config/sendTypeSwitch/{id}/{flag}")
    @ApiOperation(value = "发送渠道开关配置")
    @ApiOperationSupport(order = 5)
    public ApiResult<Boolean> sendTypeSwitchUpdate(@PathVariable("id") Long id,
                                                                  @PathVariable("flag")  Boolean flag ) {
            //  如果没有配置过渠道信息，失败返回，提示请配置。
        return sysMsgTemplateService.sendTypeSwitchUpdate(id,flag);
    }

    @PostMapping("/delete")
    @ApiOperation(value = "模板批量删除-循环删除发送配置")
    @ApiOperationSupport(order = 6)
    public ApiResult<Boolean> deleteSysMsgTemplate(@RequestBody TemplateDeleteVO templateDeleteVO) {
        //  如果没有配置过渠道信息，失败返回，提示请配置。
        return sysMsgTemplateService.deleteSysMsgTemplate(templateDeleteVO);
    }

    @GetMapping("/sysMsgSendType")
    @ApiOperation(value = "发送渠道类型枚举查询")
    @ApiOperationSupport(order = 7)
    public ApiResult<List<SysUdcVO>> getSysMsgSendType() {
        return  sysMsgTemplateService.getSysMsgSendType();
    }

    @GetMapping("/enum/sysMsgType")
    @ApiOperation(value = "消息类型枚举查询")
    @ApiOperationSupport(order = 8)
    public ApiResult<List<SysUdcVO>> getSysMsgTypeEnum() {
        return ApiResult.ok(
                List.of(
                        MsgTypeEnum.TEMPLATE.getUdcVO(),
                        MsgTypeEnum.CUSTOM.getUdcVO()
                )
        );
    }

}
