package com.elitescloud.cloudt.system.modules.message.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 10:07
 */
@Entity
@Table(name = "sys_msg_send_record",indexes = {
        @Index(name = "index_msgType", columnList = "msgType"),
        @Index(name = "index_sendUserId", columnList = "sendUserId"),
        @Index(name = "index_sendTime", columnList = "sendTime"),
        @Index(name = "index_sendUserId", columnList = "sendUserId"),
        @Index(name = "index_batchUuid", columnList = "batchUuid"),
        @Index(name = "index_recipientUserName", columnList = "recipientUserName"),
        @Index(name = "index_recipientUserId", columnList = "recipientUserId")
})
@org.hibernate.annotations.Table(appliesTo = "sys_msg_send_record", comment = "消息发送主记录")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "sys_msg_send_record", description = "消息发送主记录")
public class SysMsgSendRecordDO extends BaseModel  implements Serializable
{
    @ApiModelProperty("消息类型-枚举（模板、自定义）")
    @Comment("消息类型-枚举（模板、自定义）")
    @Column(length = 40 )
    private String msgType;

    @ApiModelProperty("发送人id")
    @Comment("发送人id")
    @Column(length = 40 )
    private String sendUserId;

    @ApiModelProperty("发送人名称")
    @Comment("发送人名称")
    @Column(length = 40 )
    private String sendUserName;

    @ApiModelProperty("接收人名称")
    @Comment("接收人名称")
    @Column(length = 40 )
    private String recipientUserName;

    @ApiModelProperty("接收人id")
    @Comment("接收人id")
    @Column(length = 40 )
    private String recipientUserId;
    @ApiModelProperty("发送人编码")
    @Comment("发送人编码")
    @Column(length = 40 )
    private String sendUserCode;
    @ApiModelProperty("接收人编码")
    @Comment("发送人编码")
    @Column(length = 40 )
    private String recipientUserCode;
    @ApiModelProperty("发送时间")
    @Comment("发送时间")
    @Column()
    private LocalDateTime sendTime;

    @ApiModelProperty("批量号")
    @Comment("批量号")
    @Column(length = 200 )
    private String batchUuid;
    @ApiModelProperty("模板编码")
    @Comment("模板编码")
    @Column(length = 200 )
    private String templateCode;

    @ApiModelProperty("模板名称")
    @Comment("模板名称")
    @Column(length = 200 )
    private String templateName;
    @ApiModelProperty("自定义参数json")
    @Comment("自定义参数json")
    @Column(length = 2000 )
    private String customParamJson;

    @ApiModelProperty("发送参数json")
    @Comment("发送参数json")
    @Lob
    private String sendParamJson;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysMsgSendRecordDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysMsgSendRecordDO entity = (SysMsgSendRecordDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}