package com.elitescloud.cloudt.system.modules.message.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 10:08
 */
@Entity
@Table(name = "sys_msg_send_record_dtl",indexes = {
        @Index(name = "index_templateCode", columnList = "templateCode"),
        @Index(name = "index_msgSendRecordId", columnList = "msgSendRecordId"),
        @Index(name = "index_sendState", columnList = "sendState"),
        @Index(name = "index_sentTypeCode", columnList = "sentTypeCode"),
        @Index(name = "index_msgType", columnList = "msgType"),
        @Index(name = "index_sendUserId", columnList = "sendUserId"),
        @Index(name = "idx_msg_rdl_sendusercode", columnList = "sendUserCode"),
        @Index(name = "index_sentTimeStart", columnList = "sentTimeStart"),
        @Index(name = "index_sendState", columnList = "sendState"),
        @Index(name = "index_batchUuid", columnList = "batchUuid"),
        @Index(name = "idx_msg_rdl_recipentusercode", columnList = "recipientUserCode"),
        @Index(name = "index_recipientUserId", columnList = "recipientUserId"),

}
)
@org.hibernate.annotations.Table(appliesTo = "sys_msg_send_record_dtl", comment = "消息发送明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "sys_msg_send_record_dtl", description = "消息发送明细表")
public class SysMsgSendRecordDtlDO extends BaseModel implements Serializable
{
    @ApiModelProperty("消息发送主表")
    @Comment("消息发送主表")
    @Column()
    Long msgSendRecordId;

    @ApiModelProperty("消息类型-枚举-模板-自定义")
    @Comment("消息类型-枚举-模板-自定义")
    @Column(length = 200 )
    String msgType;

    @ApiModelProperty("发送状态-枚举-发送中，成功，失败")
    @Comment("发送状态-枚举-发送中，成功，失败")
    @Column(length = 40 )
    String sendState;

    @ApiModelProperty("发送类型-短信-邮箱-站内信-站内提醒websoket")
    @Comment("发送类型-短信-邮箱-站内信-站内提醒websoket")
    @Column(length = 200 )
    String sentTypeCode;

    @ApiModelProperty("发送类型名称")
    @Comment("发送类型名称")
    @Column(length = 200 )
    String sendTypeName;

//    @ApiModelProperty("发送类型的配置参数json（冗余，展示，重试，追溯使用）")
//    @Comment("发送类型的配置参数json（冗余，展示，重试，追溯使用）")
//    @Lob
//    String sendTypeConfigJson;

    @ApiModelProperty("发送时间")
    @Comment("发送时间")
    @Column()
    private LocalDateTime sentTimeStart;

    @ApiModelProperty("发送时间结束")
    @Comment("发送回执时间")
    @Column()
    private LocalDateTime sentTimeEnd;

    @ApiModelProperty("发送回执信息")
    @Comment("发送回执信息")
    @Column(length = 2000 )
    private String sentEndMessage;

    @ApiModelProperty("发送系统内异常信息")
    @Comment("发送系统内异常信息")
    @Lob
    private String sentErrMessage;

    @ApiModelProperty("发送人id")
    @Comment("发送人id")
    @Column(length = 40 )
    private String sendUserId;

    @ApiModelProperty("发送人名称")
    @Comment("发送人名称")
    @Column(length = 200 )
    private String sendUserName;

    @ApiModelProperty("接收人名称")
    @Comment("接收人名称")
    @Column(length = 200 )
    private String recipientUserName;

    @ApiModelProperty("接收人id")
    @Comment("接收人id")
    @Column(length = 40 )
    private String recipientUserId;
    @ApiModelProperty("发送人编码")
    @Comment("发送人编码")
    @Column(length = 40 )
    private String sendUserCode;
    @ApiModelProperty("接收人编码")
    @Comment("接收人编码")
    @Column(length = 40 )
    private String recipientUserCode;

    @ApiModelProperty("模板id")
    @Comment("模板id")
    @Column()
    private Long templateId;

    @ApiModelProperty("模板编码")
    @Comment("模板编码")
    @Column(length = 200 )
    private String templateCode;

    @ApiModelProperty("模板名称")
    @Comment("模板名称")
    @Column(length = 200 )
    private String templateName;

    @ApiModelProperty("主题-暂定udc")
    @Comment("主题-暂定udc")
    @Column(length = 200 )
    private String subject;

//    @ApiModelProperty("模板标题上下文参数json")
//    @Comment("模板标题上下文参数json")
//    @Column(length = 2000 )
//    private String titleContentJson;

    @ApiModelProperty("标题内容")
    @Comment("标题内容")
    @Column(length = 200 )
    private String titleContent;

    @ApiModelProperty("消息内容")
    @Comment("消息内容")
    @Lob
    private String messageContent;

    @ApiModelProperty("模板发送参数json")
    @Comment("模板发送参数json")
    @Lob
    private String templateSendParamJson;

    @ApiModelProperty("外部模板id")
    @Comment("外部模板id")
    @Column(length = 200 )
    private String externalTemplateId;

    @ApiModelProperty("扩展参数1")
    @Comment("扩展参数1")
    @Column( )
    @Lob
    private String extend1;

    @ApiModelProperty("扩展参数2")
    @Comment("扩展参数2")
    @Column( )
    @Lob
    private String extend2;

    @ApiModelProperty("扩展参数3")
    @Comment("扩展参数3")
    @Column( )
    @Lob
    private String extend3;

    @ApiModelProperty("扩展参数4")
    @Comment("扩展参数4")
    @Column( )
    @Lob
    private String extend4;

    @ApiModelProperty("扩展参数5")
    @Comment("扩展参数5")
    @Column()
    @Lob
    private String extend5;

    @ApiModelProperty("是否已读")
    @Comment("是否已读")
    @Column()
    private Boolean readFlg;
    @ApiModelProperty("已读时间")
    @Comment("已读时间")
    @Column( )
    private String readTime;
    @ApiModelProperty("批量号")
    @Comment("批量号")
    @Column()
    private String batchUuid;
    @ApiModelProperty("自定义json参数")
    @Comment("自定义json参数")
    @Column()
    @Lob
    private String customParamJson;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysMsgSendRecordDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysMsgSendRecordDtlDO entity = (SysMsgSendRecordDtlDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }


}