package com.elitescloud.cloudt.system.modules.message.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 10:07
 */
@Entity
@Table(name = "sys_msg_send_type")
@org.hibernate.annotations.Table(appliesTo = "sys_msg_send_type", comment = "发送类型配置表（暂时配置文件，不建表）")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "sys_msg_send_type", description = "发送类型配置表（暂时配置文件，不建表）")
public class SysMsgSendTypeDO extends BaseModel  implements Serializable
{
    @ApiModelProperty("类型编码")
    @Comment("类型编码")
    @Column(length = 200 )
    String sendTypeCode;

    @ApiModelProperty("类型名称")
    @Comment("类型名称")
    @Column(length = 200 )
    String sendTypeName;

    @ApiModelProperty("类型配置json，邮箱，短信等-站内信-站内提醒websoket")
    @Comment("类型配置json，邮箱，短信等-站内信-站内提醒websoket")
    @Lob
    String sendTypeConfigJson;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysMsgSendTypeDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysMsgSendTypeDO entity = (SysMsgSendTypeDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
