package com.elitescloud.cloudt.system.modules.message.entity;


import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;


/**
 * 模板发送配置
 *
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 09:56
 */
@Entity
@Table(name = "sys_msg_template_config", indexes = {
        @Index(name = "index_templateId", columnList = "templateId"),
        @Index(name = "index_sendTypeCode", columnList = "sendTypeCode"),
        @Index(name = "index_templateCode", columnList = "templateCode"),
        @Index(name = "index_templateName", columnList = "templateName")
})
@org.hibernate.annotations.Table(appliesTo = "sys_msg_template_config", comment = "模板发送配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "sys_msg_template_config", description = "模板发送配置")
public class SysMsgTemplateConfigDO extends BaseStdModel {
    private static final long serialVersionUID = -5951577581035866722L;

    @Comment("模板id")
    @Column()
    private Long templateId;

    @Comment("模板编码")
    @Column(length = 200)
    private String templateCode;

    @Comment("模板名称")
    @Column(length = 200)
    private String templateName;

    @Comment("发送类型")
    @Column(length = 200)
    private String sendTypeCode;

    @Column()
    @Comment("发送类型开关")
    private Boolean sendTypeSwitch;

    @Comment("发送类型")
    @Column(length = 200)
    private String sendTypeName;

    @Comment("主题-暂定udc/暂时无用")
    @Column(length = 200)
    private String mesSubject;

    @Comment("标题")
    @Column(length = 200)
    private String mesTitle;

    @Comment(value = "是否富文本", defaultValue = "0")
    @Column()
    private Boolean mesRichContentSign;

    @Comment("外部模板id")
    @Column(length = 200)
    private String externalTemplateId;

    @Comment("签名")
    @Column()
    private String externalSignName;

    @Comment("内容")
    @Lob
    private String mesText;

//    @ApiModelProperty("模板发送配置JSON（暂冗余备份） 暂冗余备份")
//    @Comment("模板发送配置JSON（暂冗余备份） 暂冗余备份")
//    @Lob
//    String mesSendConfigJson;


}