package com.elitescloud.cloudt.system.modules.message.repository;


import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDtlDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 13:10
 */
public interface SysMsgSendRecordDtlRepository extends JpaRepository<SysMsgSendRecordDtlDO, Long>, QuerydslPredicateExecutor<SysMsgSendRecordDtlDO> {
    Long deleteByMsgSendRecordId(Long t);
    // 自定义查询方法


    @Modifying
    @Query("UPDATE SysMsgSendRecordDtlDO SET sentEndMessage = :sentEndMessage ,sendState=:sendState" +
            " ,sentTimeEnd=:sentTimeEnd,sentErrMessage=:sentErrMessage WHERE batchUuid = :batchUuid and sentTypeCode=:sentTypeCode")
    @Transactional(rollbackFor = Exception.class)
    int updateByCondition(@Param("sentEndMessage") String sentEndMessage,
                          @Param("sentErrMessage") String sentErrMessage,
                          @Param("sendState") String sendState,
                          @Param("sentTimeEnd") LocalDateTime sentTimeEnd,
                          @Param("batchUuid") String batchUuid,
                          @Param("sentTypeCode") String sentTypeCode);
}
