package com.elitescloud.cloudt.system.modules.message.repository;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.modules.message.bo.MsgTemplateReceiverBO;
import com.elitescloud.cloudt.system.modules.message.entity.QSysMsgTemplateReceiverDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateReceiverDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/20
 */
@Repository
public class SysMsgTemplateReceiverRepoProc extends BaseRepoProc<SysMsgTemplateReceiverDO> {
    private static final QSysMsgTemplateReceiverDO QDO = QSysMsgTemplateReceiverDO.sysMsgTemplateReceiverDO;

    public SysMsgTemplateReceiverRepoProc() {
        super(QDO);
    }

    /**
     * 根据模板ID删除
     *
     * @param templateId
     */
    public void deleteByTemplateId(long templateId) {
        super.deleteByValue(QDO.templateId, templateId);
    }

    /**
     * 根据模板ID查询
     *
     * @param templateId
     * @return
     */
    public List<MsgTemplateReceiverBO> listByTemplateId(long templateId) {
        return super.jpaQueryFactory.select(qBeanReceiverBO())
                .from(QDO)
                .where(QDO.templateId.eq(templateId))
                .fetch();
    }

    /**
     * 根据模板ID和配置ID查询
     *
     * @param templateId
     * @param configId
     * @return
     */
    public List<MsgTemplateReceiverBO> listByTemplateIdAndConfigId(long templateId, long configId) {
        return super.jpaQueryFactory.select(qBeanReceiverBO())
                .from(QDO)
                .where(QDO.templateId.eq(templateId).and(QDO.templateConfigId.eq(configId)))
                .fetch();
    }

    private QBean<MsgTemplateReceiverBO> qBeanReceiverBO() {
        return Projections.bean(MsgTemplateReceiverBO.class, QDO.templateConfigId, QDO.receiverType, QDO.receiverId, QDO.sortNo);
    }
}
