package com.elitescloud.cloudt.system.modules.message.rpc;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.zhxu.bs.BeanSearcher;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.AssignParamSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSentMsgParamDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.bo.SendTempLateMsgBO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordDtlRepository;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordRepository;
import com.elitescloud.cloudt.system.modules.message.rpc.manager.SysMsgCustomSendRpcServiceAbstract;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonService;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonServiceAbstract;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import com.elitescloud.cloudt.system.param.SysSendResultParam;
import com.elitescloud.cloudt.system.service.SysMsgCustomSendRpcService;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.http.MediaType;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description : 自定义消息发送接口 ，
 * 自定义消息复用模板消息的代码和逻辑，有部分入参会转换成模板消息的对象。
 * 公共部分参见：SysMsgSendCommonService ，SysMsgSendCommonServiceAbstract
 * @date : 2023/6/2 09:19
 */
@RestController
@RequestMapping(value = SysMsgCustomSendRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
@TenantOrgTransaction(useTenantOrg = false)
@Slf4j
public class SysMsgCustomSendRpcServiceImpl extends SysMsgCustomSendRpcServiceAbstract
        implements SysMsgCustomSendRpcService {
    private final SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository;
    private final SysMsgSendRecordRepository sysMsgSendRecordRepository;
    private final BeanSearcherFactory beanSearcherFactory;
    private final BeanSearcher beanSearcher;
    private final PlatformTransactionManager transactionManager;
    private final SysMsgSendCommonService sysMsgSendCommonService;

    public SysMsgCustomSendRpcServiceImpl(SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository,
                                          SysMsgSendRecordRepository sysMsgSendRecordRepository,
                                          BeanSearcherFactory beanSearcherFactory,
                                          PlatformTransactionManager transactionManager,
                                          SysMsgSendCommonService sysMsgSendCommonService) {
        this.sysMsgSendRecordDtlRepository = sysMsgSendRecordDtlRepository;
        this.sysMsgSendRecordRepository = sysMsgSendRecordRepository;
        this.beanSearcherFactory = beanSearcherFactory;
        this.beanSearcher = beanSearcherFactory.getBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT);
        this.transactionManager = transactionManager;
        this.sysMsgSendCommonService = sysMsgSendCommonService;
    }

    @Override
    public ApiResult<String> msgCustomEmployeeSend(EmployeeSendParamDTO param) {
        //批次ID 用于批量操作
        String uuidBatch = UUID.randomUUID().toString();
        //发送人 检查
        val sendUser = SysMsgSendCommonServiceAbstract.autoGetSender(param.getSendUser());
        param.setSendUser(sendUser);
        sysMsgSendCommonService.checkSendUser(sendUser);
        //接收人集合 检查
        val recipientUserList = param.getMsgRecipientUserDTO();
        sysMsgSendCommonService.checkRecipientEmployeeUserList(recipientUserList);
        //查询接收人员工信息并检查员工信息
        List<EmployeePagedRespBean> employeeList = sysMsgSendCommonService.getCheckEmployeePagedRespBeans(recipientUserList);

        //自定义消息发送参数 消息发送类型，title，content
        val employeeSentMsgParamDTOS = param.getSendTypeMessageMap();
        //自定义发送类型和发送参数封装模板参数复用模板逻辑
        // 查询模板配置，替换模板占位，保存主表明细表，rpc发送消息，外部模板id
        sendCustomRpcMsg(uuidBatch, sendUser, employeeList, employeeSentMsgParamDTOS,param.getMesJoinParamMap());
        return ApiResult.ok(uuidBatch);
    }

    @Override
    public ApiResult<List<SysSendResultParam>> msgCustomEmployeeSend(List<EmployeeSendParamDTO> paramList) {
        List<SysSendResultParam> resultParamList = new ArrayList<>(paramList.size());
        for (var paramDTO : paramList) {
            try {
                var sendResult = this.msgCustomEmployeeSend(paramDTO);
                resultParamList.add(new SysSendResultParam(sendResult.isSuccess(), sendResult.getMsg(), sendResult.getData()));
            } catch (Throwable e) {
                log.error("发送失败：", e);
                resultParamList.add(new SysSendResultParam(false, e.getMessage(), null));
            }
        }
        return ApiResult.ok(resultParamList);
    }

    @Override
    public ApiResult<String> customMsgTypeParamSend(AssignParamSendParamDTO param) {
        //批次ID 用于批量操作
        String uuidBatch = UUID.randomUUID().toString();
        //发送人 检查
        val sendUser = SysMsgSendCommonServiceAbstract.autoGetSender(param.getSendUser());
        param.setSendUser(sendUser);
        sysMsgSendCommonService.checkSendUser(sendUser);
        //接收人集合 检查
        val recipientUserList = param.getMsgRecipientUserDTO();
        sysMsgSendCommonService.checkRecipientAssignUserList(recipientUserList);
        //接收人员工信息封装
        List<EmployeePagedRespBean> employeeList =
                recipientUserList.stream().map(templateAssignRecipientUserDTO -> {
                    var map = templateAssignRecipientUserDTO.getRecipientUserAccountDtoMap();
                    //根据接收人参数，发送类型的参数，封装入员工信息，后续逻辑可以和员工逻辑复用
                    EmployeePagedRespBean bean =
                            sysMsgSendCommonService.setEmployeeBeanByAssignRecipientUserDTO(map, templateAssignRecipientUserDTO);
                    return bean;
                }).collect(Collectors.toList());


        //自定义发送类型和发送参数封装模板参数复用模板逻辑
        val employeeSentMsgParamDTOS = param.getSendTypeMessageMap();
        sendCustomRpcMsg(uuidBatch, sendUser, employeeList, employeeSentMsgParamDTOS,param.getMesJoinParamMap());
        return ApiResult.ok(uuidBatch);
    }

    @Override
    public ApiResult<List<SysSendResultParam>> customMsgTypeParamSend(List<AssignParamSendParamDTO> paramList) {
        List<SysSendResultParam> resultParamList = new ArrayList<>(paramList.size());
        for (var paramDTO : paramList) {
            try {
                var sendResult = this.customMsgTypeParamSend(paramDTO);
                resultParamList.add(new SysSendResultParam(sendResult.isSuccess(), sendResult.getMsg(), sendResult.getData()));
            } catch (Throwable e) {
                log.error("发送失败：", e);
                resultParamList.add(new SysSendResultParam(false, e.getMessage(), null));
            }
        }
        return ApiResult.ok(resultParamList);
    }

    /***
     * 私有方法
     * 查询模板配置，替换模板占位，保存主表明细表，rpc发送消息
     * **/
    private void sendCustomRpcMsg(String uuidBatch, MsgSendEmployeeUserDTO sendUser,
                                  List<EmployeePagedRespBean> employeeList,
                                  List<EmployeeSentMsgParamDTO> employeeSentMsgParamDTOS, Map<String, String> mesJoinParamMap) {
        List<SysMsgTemplateConfigDO> sysMsgTemplateConfigDTOList = getSysMsgTemplateConfigDOS(employeeSentMsgParamDTOS);
        SysMsgTemplateDO templateDo = getSysMsgTemplateDO();

        //消息模板明细配置，按照消息发送类型分组，并do转vo；
        Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> groupedSendMap =
                sysMsgSendCommonService.sysMsgTemplateConfigDoToVoGroupBySendTypeCode(
                        sysMsgTemplateConfigDTOList);

        SendTempLateMsgBO sendBo=new SendTempLateMsgBO(null,null,
                mesJoinParamMap,uuidBatch,sendUser,employeeList,null,null,null);
        sendBo.setGroupedSendMap(groupedSendMap);
        sendBo.setTemplateDo(templateDo);

        //事务添加消息主表和明细表数据，保障基础数据记录，根据接收人添加主表，根据模板发送类型配置，依次添加明细表。
        Map<MsgSendTypeEnum, List<MessageAccountVO>> sendPathMap =
                sysMsgSendCommonService.saveSendRecordToMsgSendTypeEnumListMap(sendBo,
                        MsgTypeEnum.CUSTOM);

        Map<MsgSendTypeEnum, Map<String,String>> templateParamsMap = employeeSentMsgParamDTOS == null ? Collections.emptyMap() :
                employeeSentMsgParamDTOS.stream().collect(Collectors.toMap(EmployeeSentMsgParamDTO::getMsgSendTypeEnum,
                        t -> ObjectUtil.defaultIfNull(t.getExternalTemplateParams(), Collections.emptyMap()), (t1, t2) -> t1));

        /**
         * 批量发送消息，根据发送类型批量发送
         * 获取发送类型对应的发送数据，sendPathMap获取，根据模板的内容和标题发送msgTemplateTxtReplaceDTOS
         * 发送完一个类型uuidBatch+sendType批量更新明细的发送状态
         * **/
        groupedSendMap.forEach((sendTypeEnum, msgTemplateTxtReplaceDTOS) -> {
                    sysMsgSendCommonService.sendBatchMsg(uuidBatch, sendPathMap.get(sendTypeEnum),
                            sendTypeEnum, msgTemplateTxtReplaceDTOS, templateParamsMap.get(sendTypeEnum),
                            null,null);
                }
        );
    }
}
