package com.elitescloud.cloudt.system.modules.message.rpc;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.system.dto.req.msg.interior.InteriorReadUpdateDTO;
import com.elitescloud.cloudt.system.dto.req.msg.interior.SysMsgSendRecordDtlQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysMsgSendRecordDtlDTO;
import com.elitescloud.cloudt.system.modules.message.service.SysMsgSendRecordService;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordDtlInteriorQueryVO;
import com.elitescloud.cloudt.system.param.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.param.SysMsgViewResultDTO;
import com.elitescloud.cloudt.system.service.SysMsgInteriorRpcService;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description : 站内消息远程接口
 * @date : 2023/5/25 15:58
 */
@RestController
@RequestMapping(value = SysMsgInteriorRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
@TenantOrgTransaction(useTenantOrg = false)
public class SysMsgInteriorRpcServiceImpl implements SysMsgInteriorRpcService {

    private final SysMsgSendRecordService sysMsgSendRecordService;

    public SysMsgInteriorRpcServiceImpl(SysMsgSendRecordService sysMsgSendRecordService) {
        this.sysMsgSendRecordService = sysMsgSendRecordService;
    }

    @Override
    public ApiResult<PagingVO<SysMsgSendRecordDtlDTO>> sysMsgSendRecordDtlInteriorQuery(
            SysMsgSendRecordDtlQueryDTO dto) {
        SysMsgSendRecordDtlInteriorQueryVO vo = new SysMsgSendRecordDtlInteriorQueryVO();
        BeanUtil.copyProperties(dto, vo);
        vo.setCurrent(dto.current);
        var result = sysMsgSendRecordService.sysMsgSendRecordDtlInteriorQuery(vo);
        if (result.isSuccess()) {

            if( result.getData()!=null&& result.getData().getTotalCount()!=null) {
                Long totalCount = result.getData().getTotalCount().longValue();
            var sysMsgSendRecordDtlDTOS = result.getData().getDataList().stream()
                    .map(sysMsgSendRecordDtlQueryBean -> {
                        SysMsgSendRecordDtlDTO sysMsgSendRecordDtlDTO = new SysMsgSendRecordDtlDTO();
                        BeanUtil.copyProperties(sysMsgSendRecordDtlQueryBean, sysMsgSendRecordDtlDTO);
                        return sysMsgSendRecordDtlDTO;
                    }).collect(Collectors.toList());
                var pvo = PagingVO.<SysMsgSendRecordDtlDTO>builder()
                        .setTotal(totalCount)
                        .setRecords(sysMsgSendRecordDtlDTOS)
                        .build();
                return ApiResult.ok(pvo);
            }else{
                var pvo = PagingVO.<SysMsgSendRecordDtlDTO>builder()
                        .setTotal(0)
                        .setRecords(null)
                        .build();
                return ApiResult.ok(pvo);
            }

        }else{
            return ApiResult.fail(result.getErrorMsg());
        }

    }

    @Override
    public ApiResult<Boolean> sysMsgSendRecordDtlInteriorReadUpdate(
            InteriorReadUpdateDTO dto) {
        return sysMsgSendRecordService
                .interiorReadUpdate(dto.getSendRecordDtlId(),dto.getReadFlag());
    }

    @Override
    public ApiResult<List<SysMsgSentResultDTO>> querySentResult(Set<String> recordIds) {
        return sysMsgSendRecordService.querySentResult(recordIds);
    }

    @Override
    public ApiResult<List<SysMsgViewResultDTO>> getViewedResult(String recordId) {
        return sysMsgSendRecordService.getViewedResult(recordId);
    }
}
