package com.elitescloud.cloudt.system.modules.message.rpc.manager;

import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSentMsgParamDTO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/6/2 09:20
 */
public abstract class SysMsgCustomSendRpcServiceAbstract  {

    /***
     *  将自定义发送类型和参数封装成模板配置，复用模板逻辑
     * @param employeeSentMsgParamDTOS 自定义发送类型和参数
     * @return 封装模板配置
     */
    protected static List<SysMsgTemplateConfigDO> getSysMsgTemplateConfigDOS(List<EmployeeSentMsgParamDTO> employeeSentMsgParamDTOS) {

        //将自定义发送类型和参数封装成模板配置，复用模板逻辑
        List<SysMsgTemplateConfigDO> sysMsgTemplateConfigDTOList =
                employeeSentMsgParamDTOS.stream().map(employeeSentMsgParamDTO -> {
                    SysMsgTemplateConfigDO sysMsgTemplateConfigDO=new SysMsgTemplateConfigDO();
                    sysMsgTemplateConfigDO.setTemplateId(0L);
                    sysMsgTemplateConfigDO.setTemplateCode("");
                    sysMsgTemplateConfigDO.setTemplateName("");
                    sysMsgTemplateConfigDO.setSendTypeCode(employeeSentMsgParamDTO.getMsgSendTypeEnum().name());
                    sysMsgTemplateConfigDO.setSendTypeSwitch(true);
                    sysMsgTemplateConfigDO.setSendTypeName(employeeSentMsgParamDTO.getMsgSendTypeEnum().getDescription());
                    sysMsgTemplateConfigDO.setMesSubject("");
                    sysMsgTemplateConfigDO.setMesTitle(employeeSentMsgParamDTO.getTitle());
                    sysMsgTemplateConfigDO.setMesRichContentSign(true);
                    sysMsgTemplateConfigDO.setExternalTemplateId(employeeSentMsgParamDTO.getExternalTemplateId());
                    sysMsgTemplateConfigDO.setMesText(employeeSentMsgParamDTO.getContent());
                    sysMsgTemplateConfigDO.setId(0L);
                    return sysMsgTemplateConfigDO;
                }).collect(Collectors.toList());
        return sysMsgTemplateConfigDTOList;
    }

    /**
     * 初始化一个空模板do，用于复用模板逻辑
     * @return do
     */
    protected static SysMsgTemplateDO getSysMsgTemplateDO() {
        SysMsgTemplateDO templateDo=new SysMsgTemplateDO();
        templateDo.setTemplateCode("");
        templateDo.setTemplateName("");
        templateDo.setTemplateGroup("");
        templateDo.setTemplateDescribe("");
        templateDo.setId(0L);
        return templateDo;
    }
}
