package com.elitescloud.cloudt.system.modules.message.sbean;

import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.cloudt.system.model.vo.sbean.BasicsBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/25 09:08
 */
@SearchBean(
        tables = "sys_msg_send_record so",
        where = "so.delete_flag = 0",
        autoMapTo="so"
//        dataSource = "systemDs"
)
@Data
public class SysMsgSendRecordQueryBean extends BasicsBean {

    @ApiModelProperty("消息类型-枚举（模板、自定义）")
    private String msgType;

    @ApiModelProperty("发送人id")
    private String sendUserId;

    @ApiModelProperty("发送人名称")
    private String sendUserName;

    @ApiModelProperty("接收人名称")
    private String recipientUserName;

    @ApiModelProperty("接收人id")
    private String recipientUserId;

    @ApiModelProperty("发送时间")
    private LocalDateTime sendTime;

    @ApiModelProperty("批量号")
    private String batchUuid;
    @ApiModelProperty("模板编码")
    private String templateCode;

    @ApiModelProperty("模板名称")
    private String templateName;
    @ApiModelProperty("自定义json参数")
    private String customParamJson;
}
