package com.elitescloud.cloudt.system.modules.message.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgTemplateQueryVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateAndConfigSaveVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateAndConfigUpdateVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateDeleteVO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplatePageRespVO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateRespVO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author : chen.niu
 * @description : 消息模板相关接口
 * @date : 2023/5/23 12:30
 */

public interface SysMsgTemplateService {

    ApiResult<List<SysUdcVO>> getSysMsgSendType();
    /**分页查询消息模板**/
    ApiResult<PagingVO<SysMsgTemplatePageRespVO>> getSysMsgTemplateList(SysMsgTemplateQueryVO queryVO);
    /*****获取消息模板详情* ****/
    ApiResult<SysMsgTemplateRespVO> getSysMsgTemplate(Long id, Boolean queryTemplateConfigFlag);
    /***** 新增消息模板与配置* ****/
    ApiResult<Long> templateAndConfigSave(TemplateAndConfigSaveVO vo);
    /*****修改消息模板与配置* ****/
    ApiResult<Long> templateAndConfigUpdate(Long id, TemplateAndConfigUpdateVO vo);
    /***** 发送渠道开关配置* ****/
    ApiResult<Boolean> sendTypeSwitchUpdate(Long id, Boolean flag);
    /*****模板批量删除-循环删除发送配置****/
    ApiResult<Boolean> deleteSysMsgTemplate(TemplateDeleteVO templateDeleteVO);

    /**
     * 查询默认接收人
     *
     * @param templateCode 模板编码
     * @return 消息接收人
     */
    ApiResult<Map<MsgSendTypeEnum, Set<Long>>> queryDefaultReceivers(String templateCode);
}

