package com.elitescloud.cloudt.system.modules.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserAccountDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateTxtReplaceDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.bo.SendTempLateMsgBO;
import com.elitescloud.cloudt.system.modules.message.convert.SysMsgTemplateConfigConvert;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDtlDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/6/2 09:24
 */
@Slf4j
public abstract class SysMsgSendCommonServiceAbstract {
    private final ObjectMapper objectMapper = ObjectMapperFactory.instance();
    private static final TemplateEngine engine = TemplateUtil.createEngine(new TemplateConfig());

    public String toJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("JSON序列化异常", e);
        }
    }

    /**
     * 分组占位符集合，按照发送类型分组，便于查找，
     *
     * @param templateContentReplaceDTOS 模板参数
     * @return 如果没有返回null
     */
    public  Map<MsgSendTypeEnum, List<TemplateTxtReplaceDTO>> msgTemplateTxtReplaceGroupBySendType(List<TemplateTxtReplaceDTO> templateContentReplaceDTOS) {
        if (!CollectionUtils.isEmpty(templateContentReplaceDTOS)) {
            return templateContentReplaceDTOS.stream()
                    .collect(Collectors.groupingBy(msgTemplateTxtReplaceDTO ->
                            msgTemplateTxtReplaceDTO.getMsgSendTypeEnum()));
        } else {
            return new HashMap<>();
        }
    }


    /**
     * 消息模板明细配置，按照消息发送类型分组，并do转vo；不使用JPA DO 防止增加事务处理 set值后自动刷新数据库
     *
     * @param sysMsgTemplateConfigDTOList 入参
     * @return 分组后数据
     */
    public Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> sysMsgTemplateConfigDoToVoGroupBySendTypeCode(
            List<SysMsgTemplateConfigDO> sysMsgTemplateConfigDTOList) {
        //不使用JPA DO 防止增加事务处理 set值后自动刷新数据库。
        List<SysMsgTemplateConfigVO> sysMsgTemplateConfigVOList =
                sysMsgTemplateConfigDTOList.stream()
                        .map(sysMsgTemplateConfigDO -> {
                                    try {
                                        MsgSendTypeEnum.valueOf(sysMsgTemplateConfigDO.getSendTypeCode());
                                    } catch (Exception e) {
                                        throw new BusinessException("消息服务请求-系统异常：不存在的消息发送类型编码：" + sysMsgTemplateConfigDO.getSendTypeCode());
                                    }
                                    return SysMsgTemplateConfigConvert.INSTANCE.doToVo(sysMsgTemplateConfigDO);
                                }
                        ).collect(Collectors.toList());
        //模板发送类型明细配置，按照发送类型分组
        return sysMsgTemplateConfigVOList.stream()
                .collect(Collectors.toMap(t -> MsgSendTypeEnum.valueOf(t.getSendTypeCode()), t -> t, (t1, t2) -> t1));
    }

    /***
     * 将模板的标题Title入参和模板发送渠道类型配置做占位符替换。
     * @param tid 模板id
     * @param msgTemplateTitleMap 模板入参
     * @param groupedSendMap 模板参数
     */
    public  void msgTemplateSetMesTitle(Long tid, Map<String, String> msgTemplateTitleMap,
                                Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> groupedSendMap) {
        if (CollUtil.isEmpty(msgTemplateTitleMap)) {
            log.warn("未传递标题模板参数：{}", tid);
            return;
        }

        for (Map.Entry<MsgSendTypeEnum, SysMsgTemplateConfigVO> entry : groupedSendMap.entrySet()) {
            if (CharSequenceUtil.isBlank(entry.getValue().getMesTitle())) {
                continue;
            }
            String text = msgTemplateRender(entry.getValue().getMesTitle(), msgTemplateTitleMap);
            //设置内容数据
            entry.getValue().setMesTitle(text);
        }
    }


    /***
     * 将模板的内容content MesText 入参和模板发送渠道类型配置做占位符替换。
     * @param tid 模板id
     * @param msgTemplateTxtMap 模板入参
     * @param groupedSendMap 模板参数
     */
    public void msgTemplateSetMesText(Long tid, Map<String, String> msgTemplateTxtMap,
                                      Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> groupedSendMap) {
        if (CollUtil.isEmpty(msgTemplateTxtMap)) {
            log.warn("未传递内容模板参数：{}", tid);
            return;
        }

        for (Map.Entry<MsgSendTypeEnum, SysMsgTemplateConfigVO> entry : groupedSendMap.entrySet()) {
            if (CharSequenceUtil.isBlank(entry.getValue().getMesText())) {
                continue;
            }
            String text = msgTemplateRender(entry.getValue().getMesText(), msgTemplateTxtMap);
            //设置内容数据
            entry.getValue().setMesText(text);
            entry.getValue().setBusinessData(msgTemplateTxtMap);
        }
    }

    /***
     * list null 空，大于1的判断， 如果==1返回true  否则false
     * @param isEmptyMsgLogAction 异常入参
     * @param sizeGreaterErrorMsg 个数提醒
     * @param list 集合
     * @return 是否==1
     */
    public static boolean checkMsgListEmptySize(Consumer<Logger> isEmptyMsgLogAction,
                                         String sizeGreaterErrorMsg,
                                         List list) {
        if (CollectionUtils.isEmpty(list)) {
            isEmptyMsgLogAction.accept(log);
            return false;
        } else if (list.size() > 1) {
            throw new BusinessException(sizeGreaterErrorMsg);
        } else {
            return list.size() == 1;
        }
    }

    /***字符串占位符替换${}**/
    public static String msgTemplateRender(String mesTitle, Map<String, String> titleHashMap) {
        //自动根据用户引入的模板引擎库的jar来自动选择使用的引擎
        //TemplateConfig为模板引擎的选项，可选内容有字符编码、模板路径、模板加载方式等，默认通过模板字符串渲染
        Template template = engine.getTemplate(mesTitle);
        return template.render(titleHashMap);
    }

    public static MsgSendEmployeeUserDTO autoGetSender(MsgSendEmployeeUserDTO userDTO) {
        if (userDTO != null && userDTO.getUserId() != null) {
            return userDTO;
        }
        userDTO = new MsgSendEmployeeUserDTO();

        // 获取当前用户
        var currentUser = SecurityContextUtil.currentUser();
        if (currentUser != null) {
            userDTO.setUserId(currentUser.getUserId());
            userDTO.setUserName(currentUser.getUsername());
            userDTO.setUserStandby(currentUser.getUser().getPrettyName());
            return userDTO;
        }

        userDTO.setUserId(-1L);
        userDTO.setUserName("系统");
        userDTO.setUserStandby("系统自动发送");
        return userDTO;
    }

    /**
     * 检查用户对象
     **/
    public void checkSendUser(MsgSendEmployeeUserDTO sendUser) {
        Assert.notNull(sendUser, "消息服务-信息发送人数据不能为空");
        Assert.notNull(sendUser.getUserId(), "消息服务-信息发送人ID数据不能为空");
    }

    /***检查接收人对象**/
    public void checkRecipientEmployeeUserList(List<MsgRecipientUserDTO> recipientUserList) {
        Assert.notEmpty(recipientUserList, "消息服务-信息接收人集合数据不能为空");
        recipientUserList.forEach((user) -> {
            Assert.notNull(user, "消息服务-信息接收人数据不能为空");
            Assert.notNull(user.getUserId(), "消息服务-信息接收人ID不能为空");
        });
    }



    /***检查接收人对象**/
    public void checkRecipientAssignUserList(List<TemplateAssignRecipientUserDTO> recipientUserList) {
        Assert.notEmpty(recipientUserList, "消息服务-信息接收人集合数据不能为空");
        recipientUserList.forEach((user) -> {
            Assert.notNull(user, "消息服务-信息接收人数据不能为空");
            Assert.notEmpty(user.getRecipientUserAccountDtoMap(), "消息服务-信息接收人发送参数不能为空");
        });
    }

    /**
     * 检查模板编码
     **/
    public void checkTemplateCode(String templateCode) {
        Assert.notNull(templateCode, "消息服务-模板编码不能为空");
    }


    /**
     * 找出不匹配的雇员id
     *
     * @param userIds  雇员id
     * @param employeeList 雇员查询的对象
     * @return 不匹配的雇员id
     */
    public List<Long> checkFindMismatchedEmployeeIds(Collection<Long> userIds,
                                              List<EmployeePagedRespBean> employeeList) {
        var notUserIds = userIds.stream()
                .filter(userId -> employeeList.stream()
                        .noneMatch(employee -> employee.getUserId().equals(userId)))
                .collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(notUserIds)){
            log.error("消息服务：账号id没有找到对应信息，将跳过发送，{}", notUserIds);

//            StringJoiner my_string = new StringJoiner(",");
//            // 逐一将列表中的元素添加到StringJoiner中
//            for (Long fruit : notUserIds) {
//                my_string.add(fruit.toString());
//            }
////            throw new BusinessException("消息服务：没有找到对应账号id,核对以下账号Id："+my_string);
//            log.error("消息服务：没有找到对应账号id,核对以下账号Id："+my_string);
        }

        return notUserIds;
    }




    /***封装消息发送主表对象**/
    public SysMsgSendRecordDO newSysMsgSendRecordDO(
            MsgTypeEnum msgType,
            EmployeePagedRespBean msgRecipientUserDTO,
            SendTempLateMsgBO sendBo) {
        SysMsgSendRecordDO sysMsgSendRecordDO = new SysMsgSendRecordDO();
        sysMsgSendRecordDO.setMsgType(msgType.name());
        sysMsgSendRecordDO.setSendUserId(sendBo.getSendUser().getUserId().toString());
        sysMsgSendRecordDO.setSendUserName(sendBo.getSendUser().getUserName());
        sysMsgSendRecordDO.setSendUserCode(sendBo.getSendUser().getUserCode());
        sysMsgSendRecordDO.setRecipientUserName(msgRecipientUserDTO.getLastName());
        sysMsgSendRecordDO.setRecipientUserId(msgRecipientUserDTO.getUserId().toString());
        sysMsgSendRecordDO.setRecipientUserCode(msgRecipientUserDTO.getUsername());
        sysMsgSendRecordDO.setSendTime(LocalDateTime.now());
        sysMsgSendRecordDO.setBatchUuid(sendBo.getUuidBatch());
        sysMsgSendRecordDO.setDeleteFlag(0);
        sysMsgSendRecordDO.setTemplateCode(sendBo.getTemplateDo().getTemplateCode());
        sysMsgSendRecordDO.setTemplateName(sendBo.getTemplateDo().getTemplateName());
        return sysMsgSendRecordDO;
    }

    /**
     * 封装消息发送明细表对象
     ***/
    public SysMsgSendRecordDtlDO newSysMsgSendRecordDtlDO(SendTempLateMsgBO sendBo, SysMsgSendRecordDO sysMsgSendRecordDO,
                                                   MsgSendTypeEnum sendTypeEnum, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO) {
        SysMsgSendRecordDtlDO sysMsgSendRecordDtlDO = new SysMsgSendRecordDtlDO();
        sysMsgSendRecordDtlDO.setMsgSendRecordId(sysMsgSendRecordDO.getId());
        sysMsgSendRecordDtlDO.setMsgType(sysMsgSendRecordDO.getMsgType());
        sysMsgSendRecordDtlDO.setSendState(MsgSendStateEnum.SENDING.name());
        sysMsgSendRecordDtlDO.setSentTypeCode(sendTypeEnum.name());
        sysMsgSendRecordDtlDO.setSendTypeName(sendTypeEnum.getDescription());
        sysMsgSendRecordDtlDO.setSentTimeStart(LocalDateTime.now());
//                sysMsgSendRecordDtlDO.setSentTimeEnd(LocalDateTime.now());
//                sysMsgSendRecordDtlDO.setSentEndMessage("");
//                sysMsgSendRecordDtlDO.setSentErrMessage("");
        sysMsgSendRecordDtlDO.setSendUserId(sysMsgSendRecordDO.getSendUserId());
        sysMsgSendRecordDtlDO.setSendUserName(sysMsgSendRecordDO.getSendUserName());
        sysMsgSendRecordDtlDO.setRecipientUserName(sysMsgSendRecordDO.getRecipientUserName());
        sysMsgSendRecordDtlDO.setRecipientUserId(sysMsgSendRecordDO.getRecipientUserId());
        sysMsgSendRecordDtlDO.setSendUserCode(sysMsgSendRecordDO.getSendUserCode());
        sysMsgSendRecordDtlDO.setRecipientUserCode(sysMsgSendRecordDO.getRecipientUserCode());
        sysMsgSendRecordDtlDO.setTemplateId(msgTemplateTxtReplaceDTO.getTemplateId());
        sysMsgSendRecordDtlDO.setTemplateCode(msgTemplateTxtReplaceDTO.getTemplateCode());
        sysMsgSendRecordDtlDO.setTemplateName(msgTemplateTxtReplaceDTO.getTemplateName());
//                sysMsgSendRecordDtlDO.setSubject("");
        sysMsgSendRecordDtlDO.setTitleContent(msgTemplateTxtReplaceDTO.getMesTitle());
        sysMsgSendRecordDtlDO.setMessageContent(msgTemplateTxtReplaceDTO.getMesText());
        sysMsgSendRecordDtlDO.setExternalTemplateId(msgTemplateTxtReplaceDTO.getExternalTemplateId());
        sysMsgSendRecordDtlDO.setReadFlg(false);
        sysMsgSendRecordDtlDO.setBatchUuid(sendBo.getUuidBatch());

        return sysMsgSendRecordDtlDO;
    }

    /****
     * 将模板非员工获取信息，采用传参方式的参数封装成员工的信息内，复用员工逻辑
     * @param map
     * @param templateAssignRecipientUserDTO
     * @return
     */
    public EmployeePagedRespBean setEmployeeBeanByAssignRecipientUserDTO(Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map, TemplateAssignRecipientUserDTO templateAssignRecipientUserDTO) {
        EmployeePagedRespBean bean = new EmployeePagedRespBean();
        bean.setLastName(templateAssignRecipientUserDTO.getUserName());
        bean.setId(templateAssignRecipientUserDTO.getUserId());
        if (map.containsKey(MsgSendTypeEnum.EMAIL)) {
            var emailDto = map.get(MsgSendTypeEnum.EMAIL);
            bean.setEmail(emailDto.getAccount());
            bean.setUsername(emailDto.getNickName());
            bean.setLastName(emailDto.getNickName());
        }
        if (map.containsKey(MsgSendTypeEnum.MOBILE_SMS)) {
            var smsDto = map.get(MsgSendTypeEnum.MOBILE_SMS);
            bean.setPhone(smsDto.getAccount());
            bean.setUsername(smsDto.getAccount());
        }
        if (map.containsKey(MsgSendTypeEnum.APP)) {
            var accountDTO = map.get(MsgSendTypeEnum.APP);
            bean.setUsername(accountDTO.getAccount());
        }
        if (map.containsKey(MsgSendTypeEnum.SYS_INTERIOR)) {
            var accountDTO = map.get(MsgSendTypeEnum.SYS_INTERIOR);
            bean.setUsername(accountDTO.getAccount());
        }

        bean.setUserId(0L);
        bean.setCode("");
        return bean;
    }

    public static void main(String[] args) {
        String msg="${title!''}采购订单 ";
        Map<String, String> msgTemplateTitleMap=new HashMap<>();
        Template template = engine.getTemplate(msg);

        String text =  template.render(msgTemplateTitleMap);
        System.out.println(text);
    }
}
