package com.elitescloud.cloudt.system.modules.message.vo.request;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 13:51
 */

import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel(value = "TemplateConfigSaveVO", description = "模板发送配置")
@Data
public class TemplateConfigSaveVO {

    @ApiModelProperty("发送类型")
    @NotNull
    private MsgSendTypeEnum sendType;

    @ApiModelProperty("发送类型开关")
    @NotNull
    private Boolean sendTypeSwitch = false;

    @ApiModelProperty("主题-暂定udc/暂时无用")
    private String mesSubject;

    @ApiModelProperty("标题")
    @NotBlank
    private String mesTitle;

    @ApiModelProperty("是否富文本")
    private Boolean mesRichContentSign;

    @ApiModelProperty("内容")
    @NotBlank
    private String mesText;
    @ApiModelProperty("外部模板id")
    private String externalTemplateId;
    @ApiModelProperty("外部模板签名")
    private String externalSignName;

    @ApiModelProperty("默认接收人")
    private DefaultReceiverVO defaultReceiver;
}
