package com.elitescloud.cloudt.system.provider.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcValueParam;
import com.elitescloud.cloudt.platform.service.SysPlatformUdcMngService;
import com.elitescloud.cloudt.system.convert.UdcValueConvert;
import com.elitescloud.cloudt.system.provider.export.param.UdcValueExportBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * udc值列表导出.
 *
 * @author lucan.liu
 * @date 2023/11/16
 */
@Component
public class UdcValueExportProvider implements DataExport<UdcValueExportBO, QueryUdcValueParam> {

    @Autowired
    private SysPlatformUdcMngService sysPlatformUdcMngService;

    @Override
    public String getTmplCode() {
        return "sys_udcvalue_export";
    }

    @Override
    public PagingVO<UdcValueExportBO> executeExport(QueryUdcValueParam param) {
        PagingVO<UdcValueExportBO> udcValuePage = sysPlatformUdcMngService.getUdcValuePage(param)
                .map(UdcValueConvert.INSTANCE :: udcValueMngVO2ExportBO);
        if (CollectionUtils.isEmpty(udcValuePage.getRecords())) {
            return PagingVO.empty();
        }
        return udcValuePage;
    }
}
