package com.elitescloud.cloudt.system.provider.imports.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 行政区域信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/11
 */
@Data
public class ImportAreaBO implements Serializable {
    private static final long serialVersionUID = -797502408337080591L;

    /**
     * 行政区域编码
     */
    @NotBlank(message = "行政区域编码不能为空")
    private String code;

    @NotBlank(message = "行政区域名称不能为空")
    private String name;

    /**
     * 上级行政区域编码
     */
    private String parentCode;

    /**
     * {@link com.elitescloud.cloudt.constant.AreaType}
     */
    private String areaType;

    /**
     * 拼音
     */
    private String pinyin;

    /**
     * 排序号
     */
    private Integer sortNo;

    /**
     * 邮编
     */
    private String zipCode;
}
